"use strict";
(() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from2, except, desc) => {
    if (from2 && typeof from2 === "object" || typeof from2 === "function") {
      for (let key of __getOwnPropNames(from2))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from2[key], enumerable: !(desc = __getOwnPropDesc(from2, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));

  // node_modules/spark-md5/spark-md5.js
  var require_spark_md5 = __commonJS({
    "node_modules/spark-md5/spark-md5.js"(exports, module) {
      (function(factory) {
        if (typeof exports === "object") {
          module.exports = factory();
        } else if (typeof define === "function" && define.amd) {
          define(factory);
        } else {
          var glob;
          try {
            glob = window;
          } catch (e) {
            glob = self;
          }
          glob.SparkMD5 = factory();
        }
      })(function(undefined2) {
        "use strict";
        var add32 = function(a, b) {
          return a + b & 4294967295;
        }, hex_chr = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"];
        function cmn(q, a, b, x, s, t) {
          a = add32(add32(a, q), add32(x, t));
          return add32(a << s | a >>> 32 - s, b);
        }
        function md5cycle(x, k) {
          var a = x[0], b = x[1], c = x[2], d = x[3];
          a += (b & c | ~b & d) + k[0] - 680876936 | 0;
          a = (a << 7 | a >>> 25) + b | 0;
          d += (a & b | ~a & c) + k[1] - 389564586 | 0;
          d = (d << 12 | d >>> 20) + a | 0;
          c += (d & a | ~d & b) + k[2] + 606105819 | 0;
          c = (c << 17 | c >>> 15) + d | 0;
          b += (c & d | ~c & a) + k[3] - 1044525330 | 0;
          b = (b << 22 | b >>> 10) + c | 0;
          a += (b & c | ~b & d) + k[4] - 176418897 | 0;
          a = (a << 7 | a >>> 25) + b | 0;
          d += (a & b | ~a & c) + k[5] + 1200080426 | 0;
          d = (d << 12 | d >>> 20) + a | 0;
          c += (d & a | ~d & b) + k[6] - 1473231341 | 0;
          c = (c << 17 | c >>> 15) + d | 0;
          b += (c & d | ~c & a) + k[7] - 45705983 | 0;
          b = (b << 22 | b >>> 10) + c | 0;
          a += (b & c | ~b & d) + k[8] + 1770035416 | 0;
          a = (a << 7 | a >>> 25) + b | 0;
          d += (a & b | ~a & c) + k[9] - 1958414417 | 0;
          d = (d << 12 | d >>> 20) + a | 0;
          c += (d & a | ~d & b) + k[10] - 42063 | 0;
          c = (c << 17 | c >>> 15) + d | 0;
          b += (c & d | ~c & a) + k[11] - 1990404162 | 0;
          b = (b << 22 | b >>> 10) + c | 0;
          a += (b & c | ~b & d) + k[12] + 1804603682 | 0;
          a = (a << 7 | a >>> 25) + b | 0;
          d += (a & b | ~a & c) + k[13] - 40341101 | 0;
          d = (d << 12 | d >>> 20) + a | 0;
          c += (d & a | ~d & b) + k[14] - 1502002290 | 0;
          c = (c << 17 | c >>> 15) + d | 0;
          b += (c & d | ~c & a) + k[15] + 1236535329 | 0;
          b = (b << 22 | b >>> 10) + c | 0;
          a += (b & d | c & ~d) + k[1] - 165796510 | 0;
          a = (a << 5 | a >>> 27) + b | 0;
          d += (a & c | b & ~c) + k[6] - 1069501632 | 0;
          d = (d << 9 | d >>> 23) + a | 0;
          c += (d & b | a & ~b) + k[11] + 643717713 | 0;
          c = (c << 14 | c >>> 18) + d | 0;
          b += (c & a | d & ~a) + k[0] - 373897302 | 0;
          b = (b << 20 | b >>> 12) + c | 0;
          a += (b & d | c & ~d) + k[5] - 701558691 | 0;
          a = (a << 5 | a >>> 27) + b | 0;
          d += (a & c | b & ~c) + k[10] + 38016083 | 0;
          d = (d << 9 | d >>> 23) + a | 0;
          c += (d & b | a & ~b) + k[15] - 660478335 | 0;
          c = (c << 14 | c >>> 18) + d | 0;
          b += (c & a | d & ~a) + k[4] - 405537848 | 0;
          b = (b << 20 | b >>> 12) + c | 0;
          a += (b & d | c & ~d) + k[9] + 568446438 | 0;
          a = (a << 5 | a >>> 27) + b | 0;
          d += (a & c | b & ~c) + k[14] - 1019803690 | 0;
          d = (d << 9 | d >>> 23) + a | 0;
          c += (d & b | a & ~b) + k[3] - 187363961 | 0;
          c = (c << 14 | c >>> 18) + d | 0;
          b += (c & a | d & ~a) + k[8] + 1163531501 | 0;
          b = (b << 20 | b >>> 12) + c | 0;
          a += (b & d | c & ~d) + k[13] - 1444681467 | 0;
          a = (a << 5 | a >>> 27) + b | 0;
          d += (a & c | b & ~c) + k[2] - 51403784 | 0;
          d = (d << 9 | d >>> 23) + a | 0;
          c += (d & b | a & ~b) + k[7] + 1735328473 | 0;
          c = (c << 14 | c >>> 18) + d | 0;
          b += (c & a | d & ~a) + k[12] - 1926607734 | 0;
          b = (b << 20 | b >>> 12) + c | 0;
          a += (b ^ c ^ d) + k[5] - 378558 | 0;
          a = (a << 4 | a >>> 28) + b | 0;
          d += (a ^ b ^ c) + k[8] - 2022574463 | 0;
          d = (d << 11 | d >>> 21) + a | 0;
          c += (d ^ a ^ b) + k[11] + 1839030562 | 0;
          c = (c << 16 | c >>> 16) + d | 0;
          b += (c ^ d ^ a) + k[14] - 35309556 | 0;
          b = (b << 23 | b >>> 9) + c | 0;
          a += (b ^ c ^ d) + k[1] - 1530992060 | 0;
          a = (a << 4 | a >>> 28) + b | 0;
          d += (a ^ b ^ c) + k[4] + 1272893353 | 0;
          d = (d << 11 | d >>> 21) + a | 0;
          c += (d ^ a ^ b) + k[7] - 155497632 | 0;
          c = (c << 16 | c >>> 16) + d | 0;
          b += (c ^ d ^ a) + k[10] - 1094730640 | 0;
          b = (b << 23 | b >>> 9) + c | 0;
          a += (b ^ c ^ d) + k[13] + 681279174 | 0;
          a = (a << 4 | a >>> 28) + b | 0;
          d += (a ^ b ^ c) + k[0] - 358537222 | 0;
          d = (d << 11 | d >>> 21) + a | 0;
          c += (d ^ a ^ b) + k[3] - 722521979 | 0;
          c = (c << 16 | c >>> 16) + d | 0;
          b += (c ^ d ^ a) + k[6] + 76029189 | 0;
          b = (b << 23 | b >>> 9) + c | 0;
          a += (b ^ c ^ d) + k[9] - 640364487 | 0;
          a = (a << 4 | a >>> 28) + b | 0;
          d += (a ^ b ^ c) + k[12] - 421815835 | 0;
          d = (d << 11 | d >>> 21) + a | 0;
          c += (d ^ a ^ b) + k[15] + 530742520 | 0;
          c = (c << 16 | c >>> 16) + d | 0;
          b += (c ^ d ^ a) + k[2] - 995338651 | 0;
          b = (b << 23 | b >>> 9) + c | 0;
          a += (c ^ (b | ~d)) + k[0] - 198630844 | 0;
          a = (a << 6 | a >>> 26) + b | 0;
          d += (b ^ (a | ~c)) + k[7] + 1126891415 | 0;
          d = (d << 10 | d >>> 22) + a | 0;
          c += (a ^ (d | ~b)) + k[14] - 1416354905 | 0;
          c = (c << 15 | c >>> 17) + d | 0;
          b += (d ^ (c | ~a)) + k[5] - 57434055 | 0;
          b = (b << 21 | b >>> 11) + c | 0;
          a += (c ^ (b | ~d)) + k[12] + 1700485571 | 0;
          a = (a << 6 | a >>> 26) + b | 0;
          d += (b ^ (a | ~c)) + k[3] - 1894986606 | 0;
          d = (d << 10 | d >>> 22) + a | 0;
          c += (a ^ (d | ~b)) + k[10] - 1051523 | 0;
          c = (c << 15 | c >>> 17) + d | 0;
          b += (d ^ (c | ~a)) + k[1] - 2054922799 | 0;
          b = (b << 21 | b >>> 11) + c | 0;
          a += (c ^ (b | ~d)) + k[8] + 1873313359 | 0;
          a = (a << 6 | a >>> 26) + b | 0;
          d += (b ^ (a | ~c)) + k[15] - 30611744 | 0;
          d = (d << 10 | d >>> 22) + a | 0;
          c += (a ^ (d | ~b)) + k[6] - 1560198380 | 0;
          c = (c << 15 | c >>> 17) + d | 0;
          b += (d ^ (c | ~a)) + k[13] + 1309151649 | 0;
          b = (b << 21 | b >>> 11) + c | 0;
          a += (c ^ (b | ~d)) + k[4] - 145523070 | 0;
          a = (a << 6 | a >>> 26) + b | 0;
          d += (b ^ (a | ~c)) + k[11] - 1120210379 | 0;
          d = (d << 10 | d >>> 22) + a | 0;
          c += (a ^ (d | ~b)) + k[2] + 718787259 | 0;
          c = (c << 15 | c >>> 17) + d | 0;
          b += (d ^ (c | ~a)) + k[9] - 343485551 | 0;
          b = (b << 21 | b >>> 11) + c | 0;
          x[0] = a + x[0] | 0;
          x[1] = b + x[1] | 0;
          x[2] = c + x[2] | 0;
          x[3] = d + x[3] | 0;
        }
        function md5blk(s) {
          var md5blks = [], i;
          for (i = 0; i < 64; i += 4) {
            md5blks[i >> 2] = s.charCodeAt(i) + (s.charCodeAt(i + 1) << 8) + (s.charCodeAt(i + 2) << 16) + (s.charCodeAt(i + 3) << 24);
          }
          return md5blks;
        }
        function md5blk_array(a) {
          var md5blks = [], i;
          for (i = 0; i < 64; i += 4) {
            md5blks[i >> 2] = a[i] + (a[i + 1] << 8) + (a[i + 2] << 16) + (a[i + 3] << 24);
          }
          return md5blks;
        }
        function md51(s) {
          var n = s.length, state = [1732584193, -271733879, -1732584194, 271733878], i, length, tail, tmp, lo, hi;
          for (i = 64; i <= n; i += 64) {
            md5cycle(state, md5blk(s.substring(i - 64, i)));
          }
          s = s.substring(i - 64);
          length = s.length;
          tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
          for (i = 0; i < length; i += 1) {
            tail[i >> 2] |= s.charCodeAt(i) << (i % 4 << 3);
          }
          tail[i >> 2] |= 128 << (i % 4 << 3);
          if (i > 55) {
            md5cycle(state, tail);
            for (i = 0; i < 16; i += 1) {
              tail[i] = 0;
            }
          }
          tmp = n * 8;
          tmp = tmp.toString(16).match(/(.*?)(.{0,8})$/);
          lo = parseInt(tmp[2], 16);
          hi = parseInt(tmp[1], 16) || 0;
          tail[14] = lo;
          tail[15] = hi;
          md5cycle(state, tail);
          return state;
        }
        function md51_array(a) {
          var n = a.length, state = [1732584193, -271733879, -1732584194, 271733878], i, length, tail, tmp, lo, hi;
          for (i = 64; i <= n; i += 64) {
            md5cycle(state, md5blk_array(a.subarray(i - 64, i)));
          }
          a = i - 64 < n ? a.subarray(i - 64) : new Uint8Array(0);
          length = a.length;
          tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
          for (i = 0; i < length; i += 1) {
            tail[i >> 2] |= a[i] << (i % 4 << 3);
          }
          tail[i >> 2] |= 128 << (i % 4 << 3);
          if (i > 55) {
            md5cycle(state, tail);
            for (i = 0; i < 16; i += 1) {
              tail[i] = 0;
            }
          }
          tmp = n * 8;
          tmp = tmp.toString(16).match(/(.*?)(.{0,8})$/);
          lo = parseInt(tmp[2], 16);
          hi = parseInt(tmp[1], 16) || 0;
          tail[14] = lo;
          tail[15] = hi;
          md5cycle(state, tail);
          return state;
        }
        function rhex(n) {
          var s = "", j;
          for (j = 0; j < 4; j += 1) {
            s += hex_chr[n >> j * 8 + 4 & 15] + hex_chr[n >> j * 8 & 15];
          }
          return s;
        }
        function hex(x) {
          var i;
          for (i = 0; i < x.length; i += 1) {
            x[i] = rhex(x[i]);
          }
          return x.join("");
        }
        if (hex(md51("hello")) !== "5d41402abc4b2a76b9719d911017c592") {
          add32 = function(x, y) {
            var lsw = (x & 65535) + (y & 65535), msw = (x >> 16) + (y >> 16) + (lsw >> 16);
            return msw << 16 | lsw & 65535;
          };
        }
        if (typeof ArrayBuffer !== "undefined" && !ArrayBuffer.prototype.slice) {
          (function() {
            function clamp(val, length) {
              val = val | 0 || 0;
              if (val < 0) {
                return Math.max(val + length, 0);
              }
              return Math.min(val, length);
            }
            ArrayBuffer.prototype.slice = function(from2, to) {
              var length = this.byteLength, begin = clamp(from2, length), end = length, num, target, targetArray, sourceArray;
              if (to !== undefined2) {
                end = clamp(to, length);
              }
              if (begin > end) {
                return new ArrayBuffer(0);
              }
              num = end - begin;
              target = new ArrayBuffer(num);
              targetArray = new Uint8Array(target);
              sourceArray = new Uint8Array(this, begin, num);
              targetArray.set(sourceArray);
              return target;
            };
          })();
        }
        function toUtf8(str) {
          if (/[\u0080-\uFFFF]/.test(str)) {
            str = unescape(encodeURIComponent(str));
          }
          return str;
        }
        function utf8Str2ArrayBuffer(str, returnUInt8Array) {
          var length = str.length, buff = new ArrayBuffer(length), arr = new Uint8Array(buff), i;
          for (i = 0; i < length; i += 1) {
            arr[i] = str.charCodeAt(i);
          }
          return returnUInt8Array ? arr : buff;
        }
        function arrayBuffer2Utf8Str(buff) {
          return String.fromCharCode.apply(null, new Uint8Array(buff));
        }
        function concatenateArrayBuffers(first, second, returnUInt8Array) {
          var result = new Uint8Array(first.byteLength + second.byteLength);
          result.set(new Uint8Array(first));
          result.set(new Uint8Array(second), first.byteLength);
          return returnUInt8Array ? result : result.buffer;
        }
        function hexToBinaryString(hex2) {
          var bytes = [], length = hex2.length, x;
          for (x = 0; x < length - 1; x += 2) {
            bytes.push(parseInt(hex2.substr(x, 2), 16));
          }
          return String.fromCharCode.apply(String, bytes);
        }
        function SparkMD52() {
          this.reset();
        }
        SparkMD52.prototype.append = function(str) {
          this.appendBinary(toUtf8(str));
          return this;
        };
        SparkMD52.prototype.appendBinary = function(contents) {
          this._buff += contents;
          this._length += contents.length;
          var length = this._buff.length, i;
          for (i = 64; i <= length; i += 64) {
            md5cycle(this._hash, md5blk(this._buff.substring(i - 64, i)));
          }
          this._buff = this._buff.substring(i - 64);
          return this;
        };
        SparkMD52.prototype.end = function(raw) {
          var buff = this._buff, length = buff.length, i, tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], ret;
          for (i = 0; i < length; i += 1) {
            tail[i >> 2] |= buff.charCodeAt(i) << (i % 4 << 3);
          }
          this._finish(tail, length);
          ret = hex(this._hash);
          if (raw) {
            ret = hexToBinaryString(ret);
          }
          this.reset();
          return ret;
        };
        SparkMD52.prototype.reset = function() {
          this._buff = "";
          this._length = 0;
          this._hash = [1732584193, -271733879, -1732584194, 271733878];
          return this;
        };
        SparkMD52.prototype.getState = function() {
          return {
            buff: this._buff,
            length: this._length,
            hash: this._hash.slice()
          };
        };
        SparkMD52.prototype.setState = function(state) {
          this._buff = state.buff;
          this._length = state.length;
          this._hash = state.hash;
          return this;
        };
        SparkMD52.prototype.destroy = function() {
          delete this._hash;
          delete this._buff;
          delete this._length;
        };
        SparkMD52.prototype._finish = function(tail, length) {
          var i = length, tmp, lo, hi;
          tail[i >> 2] |= 128 << (i % 4 << 3);
          if (i > 55) {
            md5cycle(this._hash, tail);
            for (i = 0; i < 16; i += 1) {
              tail[i] = 0;
            }
          }
          tmp = this._length * 8;
          tmp = tmp.toString(16).match(/(.*?)(.{0,8})$/);
          lo = parseInt(tmp[2], 16);
          hi = parseInt(tmp[1], 16) || 0;
          tail[14] = lo;
          tail[15] = hi;
          md5cycle(this._hash, tail);
        };
        SparkMD52.hash = function(str, raw) {
          return SparkMD52.hashBinary(toUtf8(str), raw);
        };
        SparkMD52.hashBinary = function(content, raw) {
          var hash = md51(content), ret = hex(hash);
          return raw ? hexToBinaryString(ret) : ret;
        };
        SparkMD52.ArrayBuffer = function() {
          this.reset();
        };
        SparkMD52.ArrayBuffer.prototype.append = function(arr) {
          var buff = concatenateArrayBuffers(this._buff.buffer, arr, true), length = buff.length, i;
          this._length += arr.byteLength;
          for (i = 64; i <= length; i += 64) {
            md5cycle(this._hash, md5blk_array(buff.subarray(i - 64, i)));
          }
          this._buff = i - 64 < length ? new Uint8Array(buff.buffer.slice(i - 64)) : new Uint8Array(0);
          return this;
        };
        SparkMD52.ArrayBuffer.prototype.end = function(raw) {
          var buff = this._buff, length = buff.length, tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], i, ret;
          for (i = 0; i < length; i += 1) {
            tail[i >> 2] |= buff[i] << (i % 4 << 3);
          }
          this._finish(tail, length);
          ret = hex(this._hash);
          if (raw) {
            ret = hexToBinaryString(ret);
          }
          this.reset();
          return ret;
        };
        SparkMD52.ArrayBuffer.prototype.reset = function() {
          this._buff = new Uint8Array(0);
          this._length = 0;
          this._hash = [1732584193, -271733879, -1732584194, 271733878];
          return this;
        };
        SparkMD52.ArrayBuffer.prototype.getState = function() {
          var state = SparkMD52.prototype.getState.call(this);
          state.buff = arrayBuffer2Utf8Str(state.buff);
          return state;
        };
        SparkMD52.ArrayBuffer.prototype.setState = function(state) {
          state.buff = utf8Str2ArrayBuffer(state.buff, true);
          return SparkMD52.prototype.setState.call(this, state);
        };
        SparkMD52.ArrayBuffer.prototype.destroy = SparkMD52.prototype.destroy;
        SparkMD52.ArrayBuffer.prototype._finish = SparkMD52.prototype._finish;
        SparkMD52.ArrayBuffer.hash = function(arr, raw) {
          var hash = md51_array(new Uint8Array(arr)), ret = hex(hash);
          return raw ? hexToBinaryString(ret) : ret;
        };
        return SparkMD52;
      });
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/utils/debugBridge.js
  var DebugBridge = class _DebugBridge {
    static version = 2;
    static passwordPref = "extensions.zotero.debug-bridge.password";
    get version() {
      return _DebugBridge.version;
    }
    _disableDebugBridgePassword;
    get disableDebugBridgePassword() {
      return this._disableDebugBridgePassword;
    }
    set disableDebugBridgePassword(value) {
      this._disableDebugBridgePassword = value;
    }
    get password() {
      return BasicTool.getZotero().Prefs.get(_DebugBridge.passwordPref, true);
    }
    set password(v) {
      BasicTool.getZotero().Prefs.set(_DebugBridge.passwordPref, v, true);
    }
    constructor() {
      this._disableDebugBridgePassword = false;
      this.initializeDebugBridge();
    }
    static setModule(instance) {
      if (!instance.debugBridge?.version || instance.debugBridge.version < _DebugBridge.version) {
        instance.debugBridge = new _DebugBridge();
      }
    }
    initializeDebugBridge() {
      const debugBridgeExtension = {
        noContent: true,
        doAction: async (uri) => {
          const Zotero2 = BasicTool.getZotero();
          const window2 = Zotero2.getMainWindow();
          const uriString = uri.spec.split("//").pop();
          if (!uriString) {
            return;
          }
          const params = {};
          uriString.split("?").pop()?.split("&").forEach((p) => {
            params[p.split("=")[0]] = decodeURIComponent(p.split("=")[1]);
          });
          const skipPasswordCheck = toolkitGlobal_default.getInstance()?.debugBridge.disableDebugBridgePassword;
          let allowed = false;
          if (skipPasswordCheck) {
            allowed = true;
          } else {
            if (typeof params.password === "undefined" && typeof this.password === "undefined") {
              allowed = window2.confirm(`External App ${params.app} wants to execute command without password.
Command:
${(params.run || params.file || "").slice(0, 100)}
If you do not know what it is, please click Cancel to deny.`);
            } else {
              allowed = this.password === params.password;
            }
          }
          if (allowed) {
            if (params.run) {
              try {
                const AsyncFunction = Object.getPrototypeOf(async () => {
                }).constructor;
                const f = new AsyncFunction("Zotero,window", params.run);
                await f(Zotero2, window2);
              } catch (e) {
                Zotero2.debug(e);
                window2.console.log(e);
              }
            }
            if (params.file) {
              try {
                Services.scriptloader.loadSubScript(params.file, {
                  Zotero: Zotero2,
                  window: window2
                });
              } catch (e) {
                Zotero2.debug(e);
                window2.console.log(e);
              }
            }
          }
        },
        newChannel(uri) {
          this.doAction(uri);
        }
      };
      Services.io.getProtocolHandler("zotero").wrappedJSObject._extensions["zotero://ztoolkit-debug"] = debugBridgeExtension;
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/utils/pluginBridge.js
  var PluginBridge = class _PluginBridge {
    static version = 1;
    get version() {
      return _PluginBridge.version;
    }
    constructor() {
      this.initializePluginBridge();
    }
    static setModule(instance) {
      if (!instance.pluginBridge?.version || instance.pluginBridge.version < _PluginBridge.version) {
        instance.pluginBridge = new _PluginBridge();
      }
    }
    initializePluginBridge() {
      const { AddonManager } = _importESModule("resource://gre/modules/AddonManager.sys.mjs");
      const Zotero2 = BasicTool.getZotero();
      const pluginBridgeExtension = {
        noContent: true,
        doAction: async (uri) => {
          try {
            const uriString = uri.spec.split("//").pop();
            if (!uriString) {
              return;
            }
            const params = {};
            uriString.split("?").pop()?.split("&").forEach((p) => {
              params[p.split("=")[0]] = decodeURIComponent(p.split("=")[1]);
            });
            if (params.action === "install" && params.url) {
              if (params.minVersion && Services.vc.compare(Zotero2.version, params.minVersion) < 0 || params.maxVersion && Services.vc.compare(Zotero2.version, params.maxVersion) > 0) {
                throw new Error(`Plugin is not compatible with Zotero version ${Zotero2.version}.The plugin requires Zotero version between ${params.minVersion} and ${params.maxVersion}.`);
              }
              const addon2 = await AddonManager.getInstallForURL(params.url);
              if (addon2 && addon2.state === AddonManager.STATE_AVAILABLE) {
                addon2.install();
                hint("Plugin installed successfully.", true);
              } else {
                throw new Error(`Plugin ${params.url} is not available.`);
              }
            }
          } catch (e) {
            Zotero2.logError(e);
            hint(e.message, false);
          }
        },
        newChannel(uri) {
          this.doAction(uri);
        }
      };
      Services.io.getProtocolHandler("zotero").wrappedJSObject._extensions["zotero://plugin"] = pluginBridgeExtension;
    }
  };
  function hint(content, success) {
    const progressWindow = new Zotero.ProgressWindow({ closeOnClick: true });
    progressWindow.changeHeadline("Plugin Toolkit");
    progressWindow.progress = new progressWindow.ItemProgress(success ? "chrome://zotero/skin/tick.png" : "chrome://zotero/skin/cross.png", content);
    progressWindow.progress.setProgress(100);
    progressWindow.show();
    progressWindow.startCloseTimer(5e3);
  }

  // node_modules/zotero-plugin-toolkit/dist/managers/toolkitGlobal.js
  var ToolkitGlobal = class _ToolkitGlobal {
    debugBridge;
    pluginBridge;
    prompt;
    currentWindow;
    constructor() {
      initializeModules(this);
      this.currentWindow = BasicTool.getZotero().getMainWindow();
    }
    /**
     * Get the global unique instance of `class ToolkitGlobal`.
     * @returns An instance of `ToolkitGlobal`.
     */
    static getInstance() {
      let _Zotero;
      try {
        if (typeof Zotero !== "undefined") {
          _Zotero = Zotero;
        } else {
          _Zotero = BasicTool.getZotero();
        }
      } catch {
      }
      if (!_Zotero) {
        return void 0;
      }
      let requireInit = false;
      if (!("_toolkitGlobal" in _Zotero)) {
        _Zotero._toolkitGlobal = new _ToolkitGlobal();
        requireInit = true;
      }
      const currentGlobal = _Zotero._toolkitGlobal;
      if (currentGlobal.currentWindow !== _Zotero.getMainWindow()) {
        checkWindowDependentModules(currentGlobal);
        requireInit = true;
      }
      if (requireInit) {
        initializeModules(currentGlobal);
      }
      return currentGlobal;
    }
  };
  function initializeModules(instance) {
    new BasicTool().log("Initializing ToolkitGlobal modules");
    setModule(instance, "prompt", {
      _ready: false,
      instance: void 0
    });
    DebugBridge.setModule(instance);
    PluginBridge.setModule(instance);
  }
  function setModule(instance, key, module) {
    if (!module) {
      return;
    }
    if (!instance[key]) {
      instance[key] = module;
    }
    for (const moduleKey in module) {
      instance[key][moduleKey] ??= module[moduleKey];
    }
  }
  function checkWindowDependentModules(instance) {
    instance.currentWindow = BasicTool.getZotero().getMainWindow();
    instance.prompt = void 0;
  }
  var toolkitGlobal_default = ToolkitGlobal;

  // node_modules/zotero-plugin-toolkit/dist/version.js
  var VERSION = "5.1.0-beta.4";

  // node_modules/zotero-plugin-toolkit/dist/basic.js
  var BasicTool = class _BasicTool {
    /**
     * configurations.
     */
    _basicOptions;
    _console;
    /**
     * @deprecated Use `patcherManager` instead.
     */
    patchSign = "zotero-plugin-toolkit@3.0.0";
    static _version = VERSION;
    /**
     * Get version - checks subclass first, then falls back to parent
     */
    get _version() {
      return VERSION;
    }
    get basicOptions() {
      return this._basicOptions;
    }
    /**
     *
     * @param data Pass an BasicTool instance to copy its options.
     */
    constructor(data) {
      this._basicOptions = {
        log: {
          _type: "toolkitlog",
          disableConsole: false,
          disableZLog: false,
          prefix: ""
        },
        // We will remove this in the future, for now just let it be lazy loaded.
        get debug() {
          if (this._debug) {
            return this._debug;
          }
          this._debug = toolkitGlobal_default.getInstance()?.debugBridge || {
            disableDebugBridgePassword: false,
            password: ""
          };
          return this._debug;
        },
        api: {
          pluginID: "zotero-plugin-toolkit@windingwind.com"
        },
        listeners: {
          callbacks: {
            onMainWindowLoad: /* @__PURE__ */ new Set(),
            onMainWindowUnload: /* @__PURE__ */ new Set(),
            onPluginUnload: /* @__PURE__ */ new Set()
          },
          _mainWindow: void 0,
          _plugin: void 0
        }
      };
      try {
        if (typeof globalThis.ChromeUtils?.importESModule !== "undefined" || typeof globalThis.ChromeUtils?.import !== "undefined") {
          const { ConsoleAPI } = _importESModule("resource://gre/modules/Console.sys.mjs");
          this._console = new ConsoleAPI({
            consoleID: `${this._basicOptions.api.pluginID}-${Date.now()}`
          });
        }
      } catch {
      }
      this.updateOptions(data);
    }
    getGlobal(k) {
      if (typeof globalThis[k] !== "undefined") {
        return globalThis[k];
      }
      const _Zotero = _BasicTool.getZotero();
      try {
        const window2 = _Zotero.getMainWindow();
        switch (k) {
          case "Zotero":
          case "zotero":
            return _Zotero;
          case "window":
            return window2;
          case "windows":
            return _Zotero.getMainWindows();
          case "document":
            return window2.document;
          case "ZoteroPane":
          case "ZoteroPane_Local":
            return _Zotero.getActiveZoteroPane();
          default:
            return window2[k];
        }
      } catch (e) {
        Zotero.logError(e);
      }
    }
    /**
     * If it's an XUL element
     * @param elem
     */
    isXULElement(elem) {
      return elem.namespaceURI === "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
    }
    /**
     * Create an XUL element
     *
     * For Zotero 6, use `createElementNS`;
     *
     * For Zotero 7+, use `createXULElement`.
     * @param doc
     * @param type
     * @example
     * Create a `<menuitem>`:
     * ```ts
     * const compat = new ZoteroCompat();
     * const doc = compat.getWindow().document;
     * const elem = compat.createXULElement(doc, "menuitem");
     * ```
     */
    createXULElement(doc, type) {
      return doc.createXULElement(type);
    }
    /**
     * Output to both Zotero.debug and console.log
     * @param data e.g. string, number, object, ...
     */
    log(...data) {
      if (data.length === 0) {
        return;
      }
      let _Zotero;
      try {
        if (typeof Zotero !== "undefined") {
          _Zotero = Zotero;
        } else {
          _Zotero = _BasicTool.getZotero();
        }
      } catch {
      }
      let options;
      if (data[data.length - 1]?._type === "toolkitlog") {
        options = data.pop();
      } else {
        options = this._basicOptions.log;
      }
      try {
        if (options.prefix) {
          data.splice(0, 0, options.prefix);
        }
        if (!options.disableConsole) {
          let _console;
          if (typeof console !== "undefined") {
            _console = console;
          } else if (_Zotero) {
            _console = _Zotero.getMainWindow()?.console;
          }
          if (!_console) {
            if (!this._console) {
              return;
            }
            _console = this._console;
          }
          if (_console.groupCollapsed) {
            _console.groupCollapsed(...data);
          } else {
            _console.group(...data);
          }
          _console.trace();
          _console.groupEnd();
        }
        if (!options.disableZLog) {
          if (typeof _Zotero === "undefined") {
            return;
          }
          _Zotero.debug(data.map((d) => {
            try {
              return typeof d === "object" ? JSON.stringify(d) : String(d);
            } catch {
              _Zotero.debug(d);
              return "";
            }
          }).join("\n"));
        }
      } catch (e) {
        if (_Zotero)
          Zotero.logError(e);
        else {
          console.error(e);
        }
      }
    }
    /**
     * Patch a function
     * @deprecated Use {@link PatchHelper} instead.
     * @param object The owner of the function
     * @param funcSign The signature of the function(function name)
     * @param ownerSign The signature of patch owner to avoid patching again
     * @param patcher The new wrapper of the patched function
     */
    patch(object, funcSign, ownerSign, patcher) {
      if (object[funcSign][ownerSign]) {
        throw new Error(`${String(funcSign)} re-patched`);
      }
      this.log("patching", funcSign, `by ${ownerSign}`);
      object[funcSign] = patcher(object[funcSign]);
      object[funcSign][ownerSign] = true;
    }
    /**
     * Add a Zotero event listener callback
     * @param type Event type
     * @param callback Event callback
     */
    addListenerCallback(type, callback) {
      if (["onMainWindowLoad", "onMainWindowUnload"].includes(type)) {
        this._ensureMainWindowListener();
      }
      if (type === "onPluginUnload") {
        this._ensurePluginListener();
      }
      this._basicOptions.listeners.callbacks[type].add(callback);
    }
    /**
     * Remove a Zotero event listener callback
     * @param type Event type
     * @param callback Event callback
     */
    removeListenerCallback(type, callback) {
      this._basicOptions.listeners.callbacks[type].delete(callback);
      this._ensureRemoveListener();
    }
    /**
     * Remove all Zotero event listener callbacks when the last callback is removed.
     */
    _ensureRemoveListener() {
      const { listeners } = this._basicOptions;
      if (listeners._mainWindow && listeners.callbacks.onMainWindowLoad.size === 0 && listeners.callbacks.onMainWindowUnload.size === 0) {
        Services.wm.removeListener(listeners._mainWindow);
        delete listeners._mainWindow;
      }
      if (listeners._plugin && listeners.callbacks.onPluginUnload.size === 0) {
        Zotero.Plugins.removeObserver(listeners._plugin);
        delete listeners._plugin;
      }
    }
    /**
     * Ensure the main window listener is registered.
     */
    _ensureMainWindowListener() {
      if (this._basicOptions.listeners._mainWindow) {
        return;
      }
      const mainWindowListener = {
        onOpenWindow: (xulWindow) => {
          const domWindow = xulWindow.docShell.domWindow;
          const onload = async () => {
            domWindow.removeEventListener("load", onload, false);
            if (domWindow.location.href !== "chrome://zotero/content/zoteroPane.xhtml") {
              return;
            }
            for (const cbk of this._basicOptions.listeners.callbacks.onMainWindowLoad) {
              try {
                cbk(domWindow);
              } catch (e) {
                this.log(e);
              }
            }
          };
          domWindow.addEventListener("load", () => onload(), false);
        },
        onCloseWindow: async (xulWindow) => {
          const domWindow = xulWindow.docShell.domWindow;
          if (domWindow.location.href !== "chrome://zotero/content/zoteroPane.xhtml") {
            return;
          }
          for (const cbk of this._basicOptions.listeners.callbacks.onMainWindowUnload) {
            try {
              cbk(domWindow);
            } catch (e) {
              this.log(e);
            }
          }
        }
      };
      this._basicOptions.listeners._mainWindow = mainWindowListener;
      Services.wm.addListener(mainWindowListener);
    }
    /**
     * Ensure the plugin listener is registered.
     */
    _ensurePluginListener() {
      if (this._basicOptions.listeners._plugin) {
        return;
      }
      const pluginListener = {
        shutdown: (...args) => {
          for (const cbk of this._basicOptions.listeners.callbacks.onPluginUnload) {
            try {
              cbk(...args);
            } catch (e) {
              this.log(e);
            }
          }
        }
      };
      this._basicOptions.listeners._plugin = pluginListener;
      Zotero.Plugins.addObserver(pluginListener);
    }
    updateOptions(source) {
      if (!source) {
        return this;
      }
      if (source instanceof _BasicTool) {
        this._basicOptions = source._basicOptions;
      } else {
        this._basicOptions = source;
      }
      return this;
    }
    static getZotero() {
      if (typeof Zotero !== "undefined") {
        return Zotero;
      }
      const { Zotero: _Zotero } = ChromeUtils.importESModule("chrome://zotero/content/zotero.mjs");
      return _Zotero;
    }
  };
  var ManagerTool = class extends BasicTool {
    _ensureAutoUnregisterAll() {
      this.addListenerCallback("onPluginUnload", (params, _reason) => {
        if (params.id !== this.basicOptions.api.pluginID) {
          return;
        }
        this.unregisterAll();
      });
    }
  };
  function unregister(tools) {
    Object.values(tools).forEach((tool) => {
      if (tool instanceof ManagerTool || typeof tool?.unregisterAll === "function") {
        tool.unregisterAll();
      }
    });
  }
  function makeHelperTool(cls, options) {
    return new Proxy(cls, {
      construct(target, args) {
        const _origin = new cls(...args);
        if (_origin instanceof BasicTool) {
          _origin.updateOptions(options);
        } else {
          _origin._version = BasicTool._version;
        }
        return _origin;
      }
    });
  }
  function _importESModule(path) {
    if (typeof ChromeUtils.import === "undefined") {
      return ChromeUtils.importESModule(path, { global: "contextual" });
    }
    if (path.endsWith(".sys.mjs")) {
      path = path.replace(/\.sys\.mjs$/, ".jsm");
    }
    return ChromeUtils.import(path);
  }

  // node_modules/zotero-plugin-toolkit/dist/helpers/clipboard.js
  var ClipboardHelper = class extends BasicTool {
    transferable;
    clipboardService;
    filePath = "";
    constructor() {
      super();
      this.transferable = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
      this.clipboardService = Components.classes["@mozilla.org/widget/clipboard;1"].getService(Components.interfaces.nsIClipboard);
      this.transferable.init(null);
    }
    addText(source, type = "text/plain") {
      const str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
      str.data = source;
      if (type === "text/unicode")
        type = "text/plain";
      this.transferable.addDataFlavor(type);
      this.transferable.setTransferData(type, str, source.length * 2);
      return this;
    }
    addImage(source) {
      const parts = source.split(",");
      if (!parts[0].includes("base64")) {
        return this;
      }
      const mime = parts[0].match(/:(.*?);/)[1];
      const bstr = this.getGlobal("window").atob(parts[1]);
      let n = bstr.length;
      const u8arr = new Uint8Array(n);
      while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
      }
      const imgTools = Components.classes["@mozilla.org/image/tools;1"].getService(Components.interfaces.imgITools);
      let mimeType;
      let img;
      if (this.getGlobal("Zotero").platformMajorVersion >= 102) {
        img = imgTools.decodeImageFromArrayBuffer(u8arr.buffer, mime);
        mimeType = "application/x-moz-nativeimage";
      } else {
        mimeType = `image/png`;
        img = Components.classes["@mozilla.org/supports-interface-pointer;1"].createInstance(Components.interfaces.nsISupportsInterfacePointer);
        img.data = imgTools.decodeImageFromArrayBuffer(u8arr.buffer, mimeType);
      }
      this.transferable.addDataFlavor(mimeType);
      this.transferable.setTransferData(mimeType, img, 0);
      return this;
    }
    addFile(path) {
      const file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsIFile);
      file.initWithPath(path);
      this.transferable.addDataFlavor("application/x-moz-file");
      this.transferable.setTransferData("application/x-moz-file", file);
      this.filePath = path;
      return this;
    }
    copy() {
      try {
        this.clipboardService.setData(this.transferable, null, Components.interfaces.nsIClipboard.kGlobalClipboard);
      } catch (e) {
        if (this.filePath && Zotero.isMac) {
          Zotero.Utilities.Internal.exec(`/usr/bin/osascript`, [
            `-e`,
            `set the clipboard to POSIX file "${this.filePath}"`
          ]);
        } else {
          throw e;
        }
      }
      return this;
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/tools/ui.js
  var UITool = class extends BasicTool {
    get basicOptions() {
      return this._basicOptions;
    }
    /**
     * Store elements created with this instance
     *
     * @remarks
     * > What is this for?
     *
     * In bootstrap plugins, elements must be manually maintained and removed on exiting.
     *
     * This API does this for you.
     */
    elementCache;
    constructor(base) {
      super(base);
      this.elementCache = [];
      if (!this._basicOptions.ui) {
        this._basicOptions.ui = {
          enableElementRecord: true,
          enableElementJSONLog: false,
          enableElementDOMLog: true
        };
      }
    }
    /**
     * Remove all elements created by `createElement`.
     *
     * @remarks
     * > What is this for?
     *
     * In bootstrap plugins, elements must be manually maintained and removed on exiting.
     *
     * This API does this for you.
     */
    unregisterAll() {
      this.elementCache.forEach((e) => {
        try {
          e?.deref()?.remove();
        } catch (e2) {
          this.log(e2);
        }
      });
    }
    createElement(...args) {
      const doc = args[0];
      const tagName = args[1].toLowerCase();
      let props = args[2] || {};
      if (!tagName) {
        return;
      }
      if (typeof args[2] === "string") {
        props = {
          namespace: args[2],
          enableElementRecord: args[3]
        };
      }
      if (typeof props.enableElementJSONLog !== "undefined" && props.enableElementJSONLog || this.basicOptions.ui.enableElementJSONLog) {
        this.log(props);
      }
      props.properties = props.properties || props.directAttributes;
      props.children = props.children || props.subElementOptions;
      let elem;
      if (tagName === "fragment") {
        const fragElem = doc.createDocumentFragment();
        elem = fragElem;
      } else {
        let realElem = props.id && (props.checkExistenceParent ? props.checkExistenceParent : doc).querySelector(`#${props.id}`);
        if (realElem && props.ignoreIfExists) {
          return realElem;
        }
        if (realElem && props.removeIfExists) {
          realElem.remove();
          realElem = void 0;
        }
        if (props.customCheck && !props.customCheck(doc, props)) {
          return void 0;
        }
        if (!realElem || !props.skipIfExists) {
          let namespace = props.namespace;
          if (!namespace) {
            const mightHTML = HTMLElementTagNames.includes(tagName);
            const mightXUL = XULElementTagNames.includes(tagName);
            const mightSVG = SVGElementTagNames.includes(tagName);
            if (Number(mightHTML) + Number(mightXUL) + Number(mightSVG) > 1) {
              this.log(`[Warning] Creating element ${tagName} with no namespace specified. Found multiply namespace matches.`);
            }
            if (mightHTML) {
              namespace = "html";
            } else if (mightXUL) {
              namespace = "xul";
            } else if (mightSVG) {
              namespace = "svg";
            } else {
              namespace = "html";
            }
          }
          if (namespace === "xul") {
            realElem = this.createXULElement(doc, tagName);
          } else {
            realElem = doc.createElementNS({
              html: "http://www.w3.org/1999/xhtml",
              svg: "http://www.w3.org/2000/svg"
            }[namespace], tagName);
          }
          if (typeof props.enableElementRecord !== "undefined" ? props.enableElementRecord : this.basicOptions.ui.enableElementRecord) {
            this.elementCache.push(new WeakRef(realElem));
          }
        }
        if (props.id) {
          realElem.id = props.id;
        }
        if (props.styles && Object.keys(props.styles).length) {
          Object.keys(props.styles).forEach((k) => {
            const v = props.styles[k];
            typeof v !== "undefined" && (realElem.style[k] = v);
          });
        }
        if (props.properties && Object.keys(props.properties).length) {
          Object.keys(props.properties).forEach((k) => {
            const v = props.properties[k];
            typeof v !== "undefined" && (realElem[k] = v);
          });
        }
        if (props.attributes && Object.keys(props.attributes).length) {
          Object.keys(props.attributes).forEach((k) => {
            const v = props.attributes[k];
            typeof v !== "undefined" && realElem.setAttribute(k, String(v));
          });
        }
        if (props.classList?.length) {
          realElem.classList.add(...props.classList);
        }
        if (props.listeners?.length) {
          props.listeners.forEach(({ type, listener, options }) => {
            listener && realElem.addEventListener(type, listener, options);
          });
        }
        elem = realElem;
      }
      if (props.children?.length) {
        const subElements = props.children.map((childProps) => {
          childProps.namespace = childProps.namespace || props.namespace;
          return this.createElement(doc, childProps.tag, childProps);
        }).filter((e) => e);
        elem.append(...subElements);
      }
      if (typeof props.enableElementDOMLog !== "undefined" ? props.enableElementDOMLog : this.basicOptions.ui.enableElementDOMLog) {
        this.log(elem);
      }
      return elem;
    }
    /**
     * Append element(s) to a node.
     * @param properties See {@link ElementProps}
     * @param container The parent node to append to.
     * @returns A Node that is the appended child (aChild),
     *          except when aChild is a DocumentFragment,
     *          in which case the empty DocumentFragment is returned.
     */
    appendElement(properties, container) {
      return container.appendChild(this.createElement(container.ownerDocument, properties.tag, properties));
    }
    /**
     * Inserts a node before a reference node as a child of its parent node.
     * @param properties See {@link ElementProps}
     * @param referenceNode The node before which newNode is inserted.
     * @returns Node
     */
    insertElementBefore(properties, referenceNode) {
      if (referenceNode.parentNode)
        return referenceNode.parentNode.insertBefore(this.createElement(referenceNode.ownerDocument, properties.tag, properties), referenceNode);
      else
        this.log(`${referenceNode.tagName} has no parent, cannot insert ${properties.tag}`);
    }
    /**
     * Replace oldNode with a new one.
     * @param properties See {@link ElementProps}
     * @param oldNode The child to be replaced.
     * @returns The replaced Node. This is the same node as oldChild.
     */
    replaceElement(properties, oldNode) {
      if (oldNode.parentNode)
        return oldNode.parentNode.replaceChild(this.createElement(oldNode.ownerDocument, properties.tag, properties), oldNode);
      else
        this.log(`${oldNode.tagName} has no parent, cannot replace it with ${properties.tag}`);
    }
    /**
     * Parse XHTML to XUL fragment. For Zotero 6.
     *
     * To load preferences from a Zotero 7's `.xhtml`, use this method to parse it.
     * @param str xhtml raw text
     * @param entities dtd file list ("chrome://xxx.dtd")
     * @param defaultXUL true for default XUL namespace
     */
    parseXHTMLToFragment(str, entities = [], defaultXUL = true) {
      const parser = new DOMParser();
      const xulns = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
      const htmlns = "http://www.w3.org/1999/xhtml";
      const wrappedStr = `${entities.length ? `<!DOCTYPE bindings [ ${entities.reduce((preamble, url, index) => {
        return `${preamble}<!ENTITY % _dtd-${index} SYSTEM "${url}"> %_dtd-${index}; `;
      }, "")}]>` : ""}
      <html:div xmlns="${defaultXUL ? xulns : htmlns}"
          xmlns:xul="${xulns}" xmlns:html="${htmlns}">
      ${str}
      </html:div>`;
      this.log(wrappedStr, parser);
      const doc = parser.parseFromString(wrappedStr, "text/xml");
      this.log(doc);
      if (doc.documentElement.localName === "parsererror") {
        throw new Error("not well-formed XHTML");
      }
      const range = doc.createRange();
      range.selectNodeContents(doc.querySelector("div"));
      return range.extractContents();
    }
  };
  var HTMLElementTagNames = [
    "a",
    "abbr",
    "address",
    "area",
    "article",
    "aside",
    "audio",
    "b",
    "base",
    "bdi",
    "bdo",
    "blockquote",
    "body",
    "br",
    "button",
    "canvas",
    "caption",
    "cite",
    "code",
    "col",
    "colgroup",
    "data",
    "datalist",
    "dd",
    "del",
    "details",
    "dfn",
    "dialog",
    "div",
    "dl",
    "dt",
    "em",
    "embed",
    "fieldset",
    "figcaption",
    "figure",
    "footer",
    "form",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "head",
    "header",
    "hgroup",
    "hr",
    "html",
    "i",
    "iframe",
    "img",
    "input",
    "ins",
    "kbd",
    "label",
    "legend",
    "li",
    "link",
    "main",
    "map",
    "mark",
    "menu",
    "meta",
    "meter",
    "nav",
    "noscript",
    "object",
    "ol",
    "optgroup",
    "option",
    "output",
    "p",
    "picture",
    "pre",
    "progress",
    "q",
    "rp",
    "rt",
    "ruby",
    "s",
    "samp",
    "script",
    "section",
    "select",
    "slot",
    "small",
    "source",
    "span",
    "strong",
    "style",
    "sub",
    "summary",
    "sup",
    "table",
    "tbody",
    "td",
    "template",
    "textarea",
    "tfoot",
    "th",
    "thead",
    "time",
    "title",
    "tr",
    "track",
    "u",
    "ul",
    "var",
    "video",
    "wbr"
  ];
  var XULElementTagNames = [
    "action",
    "arrowscrollbox",
    "bbox",
    "binding",
    "bindings",
    "box",
    "broadcaster",
    "broadcasterset",
    "button",
    "browser",
    "checkbox",
    "caption",
    "colorpicker",
    "column",
    "columns",
    "commandset",
    "command",
    "conditions",
    "content",
    "deck",
    "description",
    "dialog",
    "dialogheader",
    "editor",
    "grid",
    "grippy",
    "groupbox",
    "hbox",
    "iframe",
    "image",
    "key",
    "keyset",
    "label",
    "listbox",
    "listcell",
    "listcol",
    "listcols",
    "listhead",
    "listheader",
    "listitem",
    "member",
    "menu",
    "menubar",
    "menuitem",
    "menulist",
    "menupopup",
    "menuseparator",
    "observes",
    "overlay",
    "page",
    "popup",
    "popupset",
    "preference",
    "preferences",
    "prefpane",
    "prefwindow",
    "progressmeter",
    "radio",
    "radiogroup",
    "resizer",
    "richlistbox",
    "richlistitem",
    "row",
    "rows",
    "rule",
    "script",
    "scrollbar",
    "scrollbox",
    "scrollcorner",
    "separator",
    "spacer",
    "splitter",
    "stack",
    "statusbar",
    "statusbarpanel",
    "stringbundle",
    "stringbundleset",
    "tab",
    "tabbrowser",
    "tabbox",
    "tabpanel",
    "tabpanels",
    "tabs",
    "template",
    "textnode",
    "textbox",
    "titlebar",
    "toolbar",
    "toolbarbutton",
    "toolbargrippy",
    "toolbaritem",
    "toolbarpalette",
    "toolbarseparator",
    "toolbarset",
    "toolbarspacer",
    "toolbarspring",
    "toolbox",
    "tooltip",
    "tree",
    "treecell",
    "treechildren",
    "treecol",
    "treecols",
    "treeitem",
    "treerow",
    "treeseparator",
    "triple",
    "vbox",
    "window",
    "wizard",
    "wizardpage"
  ];
  var SVGElementTagNames = [
    "a",
    "animate",
    "animateMotion",
    "animateTransform",
    "circle",
    "clipPath",
    "defs",
    "desc",
    "ellipse",
    "feBlend",
    "feColorMatrix",
    "feComponentTransfer",
    "feComposite",
    "feConvolveMatrix",
    "feDiffuseLighting",
    "feDisplacementMap",
    "feDistantLight",
    "feDropShadow",
    "feFlood",
    "feFuncA",
    "feFuncB",
    "feFuncG",
    "feFuncR",
    "feGaussianBlur",
    "feImage",
    "feMerge",
    "feMergeNode",
    "feMorphology",
    "feOffset",
    "fePointLight",
    "feSpecularLighting",
    "feSpotLight",
    "feTile",
    "feTurbulence",
    "filter",
    "foreignObject",
    "g",
    "image",
    "line",
    "linearGradient",
    "marker",
    "mask",
    "metadata",
    "mpath",
    "path",
    "pattern",
    "polygon",
    "polyline",
    "radialGradient",
    "rect",
    "script",
    "set",
    "stop",
    "style",
    "svg",
    "switch",
    "symbol",
    "text",
    "textPath",
    "title",
    "tspan",
    "use",
    "view"
  ];

  // node_modules/zotero-plugin-toolkit/dist/helpers/dialog.js
  var DialogHelper = class extends UITool {
    /**
     * Passed to dialog window for data-binding and lifecycle controls. See {@link DialogHelper.setDialogData}
     */
    dialogData;
    /**
     * Dialog window instance
     */
    window;
    elementProps;
    /**
     * Create a dialog helper with row \* column grids.
     * @param row
     * @param column
     */
    constructor(row, column) {
      super();
      if (row <= 0 || column <= 0) {
        throw new Error(`row and column must be positive integers.`);
      }
      this.elementProps = {
        tag: "vbox",
        attributes: { flex: 1 },
        styles: {
          width: "100%",
          height: "100%"
        },
        children: []
      };
      for (let i = 0; i < Math.max(row, 1); i++) {
        this.elementProps.children.push({
          tag: "hbox",
          attributes: { flex: 1 },
          children: []
        });
        for (let j = 0; j < Math.max(column, 1); j++) {
          this.elementProps.children[i].children.push({
            tag: "vbox",
            attributes: { flex: 1 },
            children: []
          });
        }
      }
      this.elementProps.children.push({
        tag: "hbox",
        attributes: { flex: 0, pack: "end" },
        children: []
      });
      this.dialogData = {};
    }
    /**
     * Add a cell at (row, column). Index starts from 0.
     * @param row
     * @param column
     * @param elementProps Cell element props. See {@link ElementProps}
     * @param cellFlex If the cell is flex. Default true.
     */
    addCell(row, column, elementProps, cellFlex = true) {
      if (row >= this.elementProps.children.length || column >= this.elementProps.children[row].children.length) {
        throw new Error(`Cell index (${row}, ${column}) is invalid, maximum (${this.elementProps.children.length}, ${this.elementProps.children[0].children.length})`);
      }
      this.elementProps.children[row].children[column].children = [
        elementProps
      ];
      this.elementProps.children[row].children[column].attributes.flex = cellFlex ? 1 : 0;
      return this;
    }
    /**
     * Add a control button to the bottom of the dialog.
     * @param label Button label
     * @param id Button id.
     * The corresponding id of the last button user clicks before window exit will be set to `dialogData._lastButtonId`.
     * @param options Options
     * @param [options.noClose] Don't close window when clicking this button.
     * @param [options.callback] Callback of button click event.
     */
    addButton(label, id, options = {}) {
      id = id || `btn-${Zotero.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`;
      this.elementProps.children[this.elementProps.children.length - 1].children.push({
        tag: "vbox",
        styles: {
          margin: "10px"
        },
        children: [
          {
            tag: "button",
            namespace: "html",
            id,
            attributes: {
              type: "button",
              "data-l10n-id": label
            },
            properties: {
              innerHTML: label
            },
            listeners: [
              {
                type: "click",
                listener: (e) => {
                  this.dialogData._lastButtonId = id;
                  if (options.callback) {
                    options.callback(e);
                  }
                  if (!options.noClose) {
                    this.window.close();
                  }
                }
              }
            ]
          }
        ]
      });
      return this;
    }
    /**
     * Dialog data.
     * @remarks
     * This object is passed to the dialog window.
     *
     * The control button id is in `dialogData._lastButtonId`;
     *
     * The data-binding values are in `dialogData`.
     * ```ts
     * interface DialogData {
     *   [key: string | number | symbol]: any;
     *   loadLock?: { promise: Promise<void>; resolve: () => void; isResolved: () => boolean }; // resolve after window load (auto-generated)
     *   loadCallback?: Function; // called after window load
     *   unloadLock?: { promise: Promise<void>; resolve: () => void }; // resolve after window unload (auto-generated)
     *   unloadCallback?: Function; // called after window unload
     *   beforeUnloadCallback?: Function; // called before window unload when elements are accessable.
     * }
     * ```
     * @param dialogData
     */
    setDialogData(dialogData) {
      this.dialogData = dialogData;
      return this;
    }
    /**
     * Open the dialog
     * @param title Window title
     * @param windowFeatures
     * @param windowFeatures.width Ignored if fitContent is `true`.
     * @param windowFeatures.height Ignored if fitContent is `true`.
     * @param windowFeatures.left
     * @param windowFeatures.top
     * @param windowFeatures.centerscreen Open window at the center of screen.
     * @param windowFeatures.resizable If window is resizable.
     * @param windowFeatures.fitContent Resize the window to content size after elements are loaded.
     * @param windowFeatures.noDialogMode Dialog mode window only has a close button. Set `true` to make maximize and minimize button visible.
     * @param windowFeatures.alwaysRaised Is the window always at the top.
     */
    open(title, windowFeatures = {
      centerscreen: true,
      resizable: true,
      fitContent: true
    }) {
      this.window = openDialog(this, `dialog-${Zotero.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`, title, this.elementProps, this.dialogData, windowFeatures);
      return this;
    }
  };
  function openDialog(dialogHelper, targetId, title, elementProps, dialogData, windowFeatures = {
    centerscreen: true,
    resizable: true,
    fitContent: true
  }) {
    dialogData = dialogData || {};
    if (!dialogData.loadLock) {
      let loadResolve;
      let isLoadResolved = false;
      const loadPromise = new Promise((resolve) => {
        loadResolve = resolve;
      });
      loadPromise.then(() => {
        isLoadResolved = true;
      });
      dialogData.loadLock = {
        promise: loadPromise,
        resolve: loadResolve,
        isResolved: () => isLoadResolved
      };
    }
    if (!dialogData.unloadLock) {
      let unloadResolve;
      const unloadPromise = new Promise((resolve) => {
        unloadResolve = resolve;
      });
      dialogData.unloadLock = {
        promise: unloadPromise,
        resolve: unloadResolve
      };
    }
    let featureString = `resizable=${windowFeatures.resizable ? "yes" : "no"},`;
    if (windowFeatures.width || windowFeatures.height) {
      featureString += `width=${windowFeatures.width || 100},height=${windowFeatures.height || 100},`;
    }
    if (windowFeatures.left) {
      featureString += `left=${windowFeatures.left},`;
    }
    if (windowFeatures.top) {
      featureString += `top=${windowFeatures.top},`;
    }
    if (windowFeatures.centerscreen) {
      featureString += "centerscreen,";
    }
    if (windowFeatures.noDialogMode) {
      featureString += "dialog=no,";
    }
    if (windowFeatures.alwaysRaised) {
      featureString += "alwaysRaised=yes,";
    }
    const win = dialogHelper.getGlobal("openDialog")("about:blank", targetId || "_blank", featureString, dialogData);
    dialogData.loadLock?.promise.then(() => {
      win.document.head.appendChild(dialogHelper.createElement(win.document, "title", {
        properties: { innerText: title },
        attributes: { "data-l10n-id": title }
      }));
      let l10nFiles = dialogData.l10nFiles || [];
      if (typeof l10nFiles === "string") {
        l10nFiles = [l10nFiles];
      }
      l10nFiles.forEach((file) => {
        win.document.head.appendChild(dialogHelper.createElement(win.document, "link", {
          properties: {
            rel: "localization",
            href: file
          }
        }));
      });
      dialogHelper.appendElement({
        tag: "fragment",
        children: [
          {
            tag: "style",
            properties: {
              // eslint-disable-next-line ts/no-use-before-define
              innerHTML: style
            }
          },
          {
            tag: "link",
            properties: {
              rel: "stylesheet",
              href: "chrome://zotero-platform/content/zotero.css"
            }
          }
        ]
      }, win.document.head);
      replaceElement(elementProps, dialogHelper);
      win.document.body.appendChild(dialogHelper.createElement(win.document, "fragment", {
        children: [elementProps]
      }));
      Array.from(win.document.querySelectorAll("*[data-bind]")).forEach((elem) => {
        const bindKey = elem.getAttribute("data-bind");
        const bindAttr = elem.getAttribute("data-attr");
        const bindProp = elem.getAttribute("data-prop");
        if (bindKey && dialogData && dialogData[bindKey]) {
          if (bindProp) {
            elem[bindProp] = dialogData[bindKey];
          } else {
            elem.setAttribute(bindAttr || "value", dialogData[bindKey]);
          }
        }
      });
      if (windowFeatures.fitContent) {
        setTimeout(() => {
          win.sizeToContent();
        }, 300);
      }
      win.focus();
    }).then(() => {
      dialogData?.loadCallback && dialogData.loadCallback();
    });
    dialogData.unloadLock?.promise.then(() => {
      dialogData?.unloadCallback && dialogData.unloadCallback();
    });
    win.addEventListener("DOMContentLoaded", function onWindowLoad(_ev) {
      win.arguments[0]?.loadLock?.resolve();
      win.removeEventListener("DOMContentLoaded", onWindowLoad, false);
    }, false);
    win.addEventListener("beforeunload", function onWindowBeforeUnload(_ev) {
      Array.from(win.document.querySelectorAll("*[data-bind]")).forEach((elem) => {
        const dialogData2 = this.window.arguments[0];
        const bindKey = elem.getAttribute("data-bind");
        const bindAttr = elem.getAttribute("data-attr");
        const bindProp = elem.getAttribute("data-prop");
        if (bindKey && dialogData2) {
          if (bindProp) {
            dialogData2[bindKey] = elem[bindProp];
          } else {
            dialogData2[bindKey] = elem.getAttribute(bindAttr || "value");
          }
        }
      });
      this.window.removeEventListener("beforeunload", onWindowBeforeUnload, false);
      dialogData?.beforeUnloadCallback && dialogData.beforeUnloadCallback();
    });
    win.addEventListener("unload", function onWindowUnload(_ev) {
      if (!this.window.arguments[0]?.loadLock?.isResolved()) {
        return;
      }
      this.window.arguments[0]?.unloadLock?.resolve();
      this.window.removeEventListener("unload", onWindowUnload, false);
    });
    if (win.document.readyState === "complete") {
      win.arguments[0]?.loadLock?.resolve();
    }
    return win;
  }
  function replaceElement(elementProps, uiTool) {
    let checkChildren = true;
    if (elementProps.tag === "select") {
      checkChildren = false;
      const customSelectProps = {
        tag: "div",
        classList: ["dropdown"],
        listeners: [
          {
            type: "mouseleave",
            listener: (ev) => {
              const select = ev.target.querySelector("select");
              select?.blur();
            }
          }
        ],
        children: [
          Object.assign({}, elementProps, {
            tag: "select",
            listeners: [
              {
                type: "focus",
                listener: (ev) => {
                  const select = ev.target;
                  const dropdown = select.parentElement?.querySelector(".dropdown-content");
                  dropdown && (dropdown.style.display = "block");
                  select.setAttribute("focus", "true");
                }
              },
              {
                type: "blur",
                listener: (ev) => {
                  const select = ev.target;
                  const dropdown = select.parentElement?.querySelector(".dropdown-content");
                  dropdown && (dropdown.style.display = "none");
                  select.removeAttribute("focus");
                }
              }
            ]
          }),
          {
            tag: "div",
            classList: ["dropdown-content"],
            children: elementProps.children?.map((option) => ({
              tag: "p",
              attributes: {
                value: option.properties?.value
              },
              properties: {
                innerHTML: option.properties?.innerHTML || option.properties?.textContent
              },
              classList: ["dropdown-item"],
              listeners: [
                {
                  type: "click",
                  listener: (ev) => {
                    const select = ev.target.parentElement?.previousElementSibling;
                    select && (select.value = ev.target.getAttribute("value") || "");
                    select?.blur();
                  }
                }
              ]
            }))
          }
        ]
      };
      for (const key in elementProps) {
        delete elementProps[key];
      }
      Object.assign(elementProps, customSelectProps);
    } else if (elementProps.tag === "a") {
      const href = elementProps?.properties?.href || "";
      elementProps.properties ??= {};
      elementProps.properties.href = "javascript:void(0);";
      elementProps.attributes ??= {};
      elementProps.attributes["zotero-href"] = href;
      elementProps.listeners ??= [];
      elementProps.listeners.push({
        type: "click",
        listener: (ev) => {
          const href2 = ev.target?.getAttribute("zotero-href");
          href2 && uiTool.getGlobal("Zotero").launchURL(href2);
        }
      });
      elementProps.classList ??= [];
      elementProps.classList.push("zotero-text-link");
    }
    if (checkChildren) {
      elementProps.children?.forEach((child) => replaceElement(child, uiTool));
    }
  }
  var style = `
html {
  color-scheme: light dark;
}
.zotero-text-link {
  -moz-user-focus: normal;
  color: -moz-nativehyperlinktext;
  text-decoration: underline;
  border: 1px solid transparent;
  cursor: pointer;
}
.dropdown {
  position: relative;
  display: inline-block;
}
.dropdown-content {
  display: none;
  position: absolute;
  background-color: var(--material-toolbar);
  min-width: 160px;
  box-shadow: 0px 0px 5px 0px rgba(0, 0, 0, 0.5);
  border-radius: 5px;
  padding: 5px 0 5px 0;
  z-index: 999;
}
.dropdown-item {
  margin: 0px;
  padding: 5px 10px 5px 10px;
}
.dropdown-item:hover {
  background-color: var(--fill-quinary);
}
`;

  // node_modules/zotero-plugin-toolkit/dist/helpers/filePicker.js
  var FilePickerHelper = class extends BasicTool {
    title;
    mode;
    filters;
    suggestion;
    directory;
    window;
    filterMask;
    constructor(title, mode, filters, suggestion, window2, filterMask, directory) {
      super();
      this.title = title;
      this.mode = mode;
      this.filters = filters;
      this.suggestion = suggestion;
      this.directory = directory;
      this.window = window2;
      this.filterMask = filterMask;
    }
    async open() {
      const Backend = ChromeUtils.importESModule("chrome://zotero/content/modules/filePicker.mjs").FilePicker;
      const fp = new Backend();
      fp.init(this.window || this.getGlobal("window"), this.title, this.getMode(fp));
      for (const [label, ext] of this.filters || []) {
        fp.appendFilter(label, ext);
      }
      if (this.filterMask)
        fp.appendFilters(this.getFilterMask(fp));
      if (this.suggestion)
        fp.defaultString = this.suggestion;
      if (this.directory)
        fp.displayDirectory = this.directory;
      const userChoice = await fp.show();
      switch (userChoice) {
        case fp.returnOK:
        case fp.returnReplace:
          return this.mode === "multiple" ? fp.files : fp.file;
        default:
          return false;
      }
    }
    getMode(fp) {
      switch (this.mode) {
        case "open":
          return fp.modeOpen;
        case "save":
          return fp.modeSave;
        case "folder":
          return fp.modeGetFolder;
        case "multiple":
          return fp.modeOpenMultiple;
        default:
          return 0;
      }
    }
    getFilterMask(fp) {
      switch (this.filterMask) {
        case "all":
          return fp.filterAll;
        case "html":
          return fp.filterHTML;
        case "text":
          return fp.filterText;
        case "images":
          return fp.filterImages;
        case "xml":
          return fp.filterXML;
        case "apps":
          return fp.filterApps;
        case "urls":
          return fp.filterAllowURLs;
        case "audio":
          return fp.filterAudio;
        case "video":
          return fp.filterVideo;
        default:
          return 1;
      }
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/helpers/guide.js
  var GuideHelper = class extends BasicTool {
    _steps = [];
    constructor() {
      super();
    }
    addStep(step) {
      this._steps.push(step);
      return this;
    }
    addSteps(steps) {
      this._steps.push(...steps);
      return this;
    }
    async show(doc) {
      if (!doc?.ownerGlobal) {
        throw new Error("Document is required.");
      }
      const guide = new Guide(doc.ownerGlobal);
      await guide.show(this._steps);
      const promise = new Promise((resolve) => {
        guide._panel.addEventListener("guide-finished", () => resolve(guide));
      });
      await promise;
      return guide;
    }
    async highlight(doc, step) {
      if (!doc?.ownerGlobal) {
        throw new Error("Document is required.");
      }
      const guide = new Guide(doc.ownerGlobal);
      await guide.show([step]);
      const promise = new Promise((resolve) => {
        guide._panel.addEventListener("guide-finished", () => resolve(guide));
      });
      await promise;
      return guide;
    }
  };
  var Guide = class {
    _window;
    _id = `guide-${Zotero.Utilities.randomString()}`;
    _panel;
    _header;
    _body;
    _footer;
    _progress;
    _closeButton;
    _prevButton;
    _nextButton;
    _steps;
    _noClose;
    _closed;
    _autoNext;
    _currentIndex;
    initialized;
    _cachedMasks = [];
    get content() {
      return this._window.MozXULElement.parseXULToFragment(`
      <panel id="${this._id}" class="guide-panel" type="arrow" align="top" noautohide="true">
          <html:div class="guide-panel-content">
              <html:div class="guide-panel-header"></html:div>
              <html:div class="guide-panel-body"></html:div>
              <html:div class="guide-panel-footer">
                  <html:div class="guide-panel-progress"></html:div>
                  <html:div class="guide-panel-buttons">
                      <button id="prev-button" class="guide-panel-button" hidden="true"></button>
                      <button id="next-button" class="guide-panel-button" hidden="true"></button>
                      <button id="close-button" class="guide-panel-button" hidden="true"></button>
                  </html:div>
              </html:div>
          </html:div>
          <html:style>
              .guide-panel {
                  background-color: var(--material-menu);
                  color: var(--fill-primary);
              }
              .guide-panel-content {
                  display: flex;
                  flex-direction: column;
                  padding: 0;
              }
              .guide-panel-header {
                  font-size: 1.2em;
                  font-weight: bold;
                  margin-bottom: 10px;
              }
              .guide-panel-header:empty {
                display: none;
              }
              .guide-panel-body {
                  align-items: center;
                  display: flex;
                  flex-direction: column;
                  white-space: pre-wrap;
              }
              .guide-panel-body:empty {
                display: none;
              }
              .guide-panel-footer {
                  display: flex;
                  flex-direction: row;
                  align-items: center;
                  justify-content: space-between;
                  margin-top: 10px;
              }
              .guide-panel-progress {
                  font-size: 0.8em;
              }
              .guide-panel-buttons {
                  display: flex;
                  flex-direction: row;
                  flex-grow: 1;
                  justify-content: flex-end;
              }
          </html:style>
      </panel>
  `);
    }
    get currentStep() {
      if (!this._steps)
        return void 0;
      return this._steps[this._currentIndex];
    }
    get currentTarget() {
      const step = this.currentStep;
      if (!step?.element)
        return void 0;
      let elem;
      if (typeof step.element === "function") {
        elem = step.element();
      } else if (typeof step.element === "string") {
        elem = this._window.document.querySelector(step.element);
      } else if (!step.element) {
        elem = this._window.document.documentElement || void 0;
      } else {
        elem = step.element;
      }
      return elem;
    }
    get hasNext() {
      return this._steps && this._currentIndex < this._steps.length - 1;
    }
    get hasPrevious() {
      return this._steps && this._currentIndex > 0;
    }
    get hookProps() {
      return {
        config: this.currentStep,
        state: {
          step: this._currentIndex,
          steps: this._steps,
          controller: this
        }
      };
    }
    get panel() {
      return this._panel;
    }
    constructor(win) {
      this._window = win;
      this._noClose = false;
      this._closed = false;
      this._autoNext = true;
      this._currentIndex = 0;
      const doc = win.document;
      const content = this.content;
      if (content) {
        doc.documentElement?.append(doc.importNode(content, true));
      }
      this._panel = doc.querySelector(`#${this._id}`);
      this._header = this._panel.querySelector(".guide-panel-header");
      this._body = this._panel.querySelector(".guide-panel-body");
      this._footer = this._panel.querySelector(".guide-panel-footer");
      this._progress = this._panel.querySelector(".guide-panel-progress");
      this._closeButton = this._panel.querySelector("#close-button");
      this._prevButton = this._panel.querySelector("#prev-button");
      this._nextButton = this._panel.querySelector("#next-button");
      this._closeButton.addEventListener("click", async () => {
        if (this.currentStep?.onCloseClick) {
          await this.currentStep.onCloseClick(this.hookProps);
        }
        this.abort();
      });
      this._prevButton.addEventListener("click", async () => {
        if (this.currentStep?.onPrevClick) {
          await this.currentStep.onPrevClick(this.hookProps);
        }
        this.movePrevious();
      });
      this._nextButton.addEventListener("click", async () => {
        if (this.currentStep?.onNextClick) {
          await this.currentStep.onNextClick(this.hookProps);
        }
        this.moveNext();
      });
      this._panel.addEventListener("popupshown", this._handleShown.bind(this));
      this._panel.addEventListener("popuphidden", this._handleHidden.bind(this));
      this._window.addEventListener("resize", this._centerPanel);
    }
    async show(steps) {
      if (steps) {
        this._steps = steps;
        this._currentIndex = 0;
      }
      const index = this._currentIndex;
      this._noClose = false;
      this._closed = false;
      this._autoNext = true;
      const step = this.currentStep;
      if (!step)
        return;
      const elem = this.currentTarget;
      if (step.onBeforeRender) {
        await step.onBeforeRender(this.hookProps);
        if (index !== this._currentIndex) {
          await this.show();
          return;
        }
      }
      if (step.onMask) {
        step.onMask({ mask: (_e) => this._createMask(_e) });
      } else {
        this._createMask(elem);
      }
      let x;
      let y = 0;
      let position = step.position || "after_start";
      if (position === "center") {
        position = "overlap";
        x = this._window.innerWidth / 2;
        y = this._window.innerHeight / 2;
      }
      this._panel.openPopup(elem, step.position || "after_start", x, y, false, false);
    }
    hide() {
      this._panel.hidePopup();
    }
    abort() {
      this._closed = true;
      this.hide();
      this._steps = void 0;
    }
    moveTo(stepIndex) {
      if (!this._steps) {
        this.hide();
        return;
      }
      if (stepIndex < 0)
        stepIndex = 0;
      if (!this._steps[stepIndex]) {
        this._currentIndex = this._steps.length;
        this.hide();
        return;
      }
      this._autoNext = false;
      this._noClose = true;
      this.hide();
      this._noClose = false;
      this._autoNext = true;
      this._currentIndex = stepIndex;
      this.show();
    }
    moveNext() {
      this.moveTo(this._currentIndex + 1);
    }
    movePrevious() {
      this.moveTo(this._currentIndex - 1);
    }
    _handleShown() {
      if (!this._steps)
        return;
      const step = this.currentStep;
      if (!step)
        return;
      this._header.innerHTML = step.title || "";
      this._body.innerHTML = step.description || "";
      this._panel.querySelectorAll(".guide-panel-button").forEach((elem) => {
        elem.hidden = true;
        elem.disabled = false;
      });
      let showButtons = step.showButtons;
      if (!showButtons) {
        showButtons = [];
        if (this.hasPrevious) {
          showButtons.push("prev");
        }
        if (this.hasNext) {
          showButtons.push("next");
        } else {
          showButtons.push("close");
        }
      }
      if (showButtons?.length) {
        showButtons.forEach((btn) => {
          this._panel.querySelector(`#${btn}-button`).hidden = false;
        });
      }
      if (step.disableButtons) {
        step.disableButtons.forEach((btn) => {
          this._panel.querySelector(`#${btn}-button`).disabled = true;
        });
      }
      if (step.showProgress) {
        this._progress.hidden = false;
        this._progress.textContent = step.progressText || `${this._currentIndex + 1}/${this._steps.length}`;
      } else {
        this._progress.hidden = true;
      }
      this._closeButton.label = step.closeBtnText || "Done";
      this._nextButton.label = step.nextBtnText || "Next";
      this._prevButton.label = step.prevBtnText || "Previous";
      if (step.onRender) {
        step.onRender(this.hookProps);
      }
      if (step.position === "center") {
        this._centerPanel();
        this._window.setTimeout(this._centerPanel, 10);
      }
    }
    async _handleHidden() {
      this._removeMask();
      this._header.innerHTML = "";
      this._body.innerHTML = "";
      this._progress.textContent = "";
      if (!this._steps)
        return;
      const step = this.currentStep;
      if (step && step.onExit) {
        await step.onExit(this.hookProps);
      }
      if (!this._noClose && (this._closed || !this.hasNext)) {
        this._panel.dispatchEvent(new this._window.CustomEvent("guide-finished"));
        this._panel.remove();
        this._window.removeEventListener("resize", this._centerPanel);
        return;
      }
      if (this._autoNext) {
        this.moveNext();
      }
    }
    _centerPanel = () => {
      const win = this._window;
      this._panel.moveTo(win.screenX + win.innerWidth / 2 - this._panel.clientWidth / 2, win.screenY + win.innerHeight / 2 - this._panel.clientHeight / 2);
    };
    _createMask(targetElement) {
      const doc = targetElement?.ownerDocument || this._window.document;
      const NS = "http://www.w3.org/2000/svg";
      const svg = doc.createElementNS(NS, "svg");
      svg.id = "guide-panel-mask";
      svg.style.position = "fixed";
      svg.style.top = "0";
      svg.style.left = "0";
      svg.style.width = "100%";
      svg.style.height = "100%";
      svg.style.zIndex = "9999";
      const mask = doc.createElementNS(NS, "mask");
      mask.id = "mask";
      const fullRect = doc.createElementNS(NS, "rect");
      fullRect.setAttribute("x", "0");
      fullRect.setAttribute("y", "0");
      fullRect.setAttribute("width", "100%");
      fullRect.setAttribute("height", "100%");
      fullRect.setAttribute("fill", "white");
      mask.appendChild(fullRect);
      if (targetElement) {
        const rect = targetElement.getBoundingClientRect();
        const targetRect = doc.createElementNS(NS, "rect");
        targetRect.setAttribute("x", rect.left.toString());
        targetRect.setAttribute("y", rect.top.toString());
        targetRect.setAttribute("width", rect.width.toString());
        targetRect.setAttribute("height", rect.height.toString());
        targetRect.setAttribute("fill", "black");
        mask.appendChild(targetRect);
      }
      const maskedRect = doc.createElementNS(NS, "rect");
      maskedRect.setAttribute("x", "0");
      maskedRect.setAttribute("y", "0");
      maskedRect.setAttribute("width", "100%");
      maskedRect.setAttribute("height", "100%");
      maskedRect.setAttribute("mask", "url(#mask)");
      maskedRect.setAttribute("opacity", "0.7");
      svg.appendChild(mask);
      svg.appendChild(maskedRect);
      this._cachedMasks.push(new WeakRef(svg));
      doc.documentElement?.appendChild(svg);
    }
    _removeMask() {
      this._cachedMasks.forEach((ref) => {
        const mask = ref.deref();
        if (mask) {
          mask.remove();
        }
      });
      this._cachedMasks = [];
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/helpers/largePref.js
  var LargePrefHelper = class extends BasicTool {
    keyPref;
    valuePrefPrefix;
    innerObj;
    hooks;
    /**
     *
     * @param keyPref The preference name for storing the keys of the data.
     * @param valuePrefPrefix The preference name prefix for storing the values of the data.
     * @param hooks Hooks for parsing the values of the data.
     * - `afterGetValue`: A function that takes the value of the data as input and returns the parsed value.
     * - `beforeSetValue`: A function that takes the key and value of the data as input and returns the parsed key and value.
     * If `hooks` is `"default"`, no parsing will be done.
     * If `hooks` is `"parser"`, the values will be parsed as JSON.
     * If `hooks` is an object, the values will be parsed by the hooks.
     */
    constructor(keyPref, valuePrefPrefix, hooks = "default") {
      super();
      this.keyPref = keyPref;
      this.valuePrefPrefix = valuePrefPrefix;
      if (hooks === "default") {
        this.hooks = defaultHooks;
      } else if (hooks === "parser") {
        this.hooks = parserHooks;
      } else {
        this.hooks = { ...defaultHooks, ...hooks };
      }
      this.innerObj = {};
    }
    /**
     * Get the object that stores the data.
     * @returns The object that stores the data.
     */
    asObject() {
      return this.constructTempObj();
    }
    /**
     * Get the Map that stores the data.
     * @returns The Map that stores the data.
     */
    asMapLike() {
      const mapLike = {
        get: (key) => this.getValue(key),
        set: (key, value) => {
          this.setValue(key, value);
          return mapLike;
        },
        has: (key) => this.hasKey(key),
        delete: (key) => this.deleteKey(key),
        clear: () => {
          for (const key of this.getKeys()) {
            this.deleteKey(key);
          }
        },
        forEach: (callback) => {
          return this.constructTempMap().forEach(callback);
        },
        get size() {
          return this._this.getKeys().length;
        },
        entries: () => {
          return this.constructTempMap().values();
        },
        keys: () => {
          const keys = this.getKeys();
          return keys[Symbol.iterator]();
        },
        values: () => {
          return this.constructTempMap().values();
        },
        [Symbol.iterator]: () => {
          return this.constructTempMap()[Symbol.iterator]();
        },
        [Symbol.toStringTag]: "MapLike",
        _this: this
      };
      return mapLike;
    }
    /**
     * Get the keys of the data.
     * @returns The keys of the data.
     */
    getKeys() {
      const rawKeys = Zotero.Prefs.get(this.keyPref, true);
      const keys = rawKeys ? JSON.parse(rawKeys) : [];
      for (const key of keys) {
        const value = "placeholder";
        this.innerObj[key] = value;
      }
      return keys;
    }
    /**
     * Set the keys of the data.
     * @param keys The keys of the data.
     */
    setKeys(keys) {
      keys = [...new Set(keys.filter((key) => key))];
      Zotero.Prefs.set(this.keyPref, JSON.stringify(keys), true);
      for (const key of keys) {
        const value = "placeholder";
        this.innerObj[key] = value;
      }
    }
    /**
     * Get the value of a key.
     * @param key The key of the data.
     * @returns The value of the key.
     */
    getValue(key) {
      const value = Zotero.Prefs.get(`${this.valuePrefPrefix}${key}`, true);
      if (typeof value === "undefined") {
        return;
      }
      const { value: newValue } = this.hooks.afterGetValue({ value });
      this.innerObj[key] = newValue;
      return newValue;
    }
    /**
     * Set the value of a key.
     * @param key The key of the data.
     * @param value The value of the key.
     */
    setValue(key, value) {
      const { key: newKey, value: newValue } = this.hooks.beforeSetValue({
        key,
        value
      });
      this.setKey(newKey);
      Zotero.Prefs.set(`${this.valuePrefPrefix}${newKey}`, newValue, true);
      this.innerObj[newKey] = newValue;
    }
    /**
     * Check if a key exists.
     * @param key The key of the data.
     * @returns Whether the key exists.
     */
    hasKey(key) {
      return this.getKeys().includes(key);
    }
    /**
     * Add a key.
     * @param key The key of the data.
     */
    setKey(key) {
      const keys = this.getKeys();
      if (!keys.includes(key)) {
        keys.push(key);
        this.setKeys(keys);
      }
    }
    /**
     * Delete a key.
     * @param key The key of the data.
     */
    deleteKey(key) {
      const keys = this.getKeys();
      const index = keys.indexOf(key);
      if (index > -1) {
        keys.splice(index, 1);
        delete this.innerObj[key];
        this.setKeys(keys);
      }
      Zotero.Prefs.clear(`${this.valuePrefPrefix}${key}`, true);
      return true;
    }
    constructTempObj() {
      return new Proxy(this.innerObj, {
        get: (target, prop, receiver) => {
          this.getKeys();
          if (typeof prop === "string" && prop in target) {
            this.getValue(prop);
          }
          return Reflect.get(target, prop, receiver);
        },
        set: (target, p, newValue, receiver) => {
          if (typeof p === "string") {
            if (newValue === void 0) {
              this.deleteKey(p);
              return true;
            }
            this.setValue(p, newValue);
            return true;
          }
          return Reflect.set(target, p, newValue, receiver);
        },
        has: (target, p) => {
          this.getKeys();
          return Reflect.has(target, p);
        },
        deleteProperty: (target, p) => {
          if (typeof p === "string") {
            this.deleteKey(p);
            return true;
          }
          return Reflect.deleteProperty(target, p);
        }
      });
    }
    constructTempMap() {
      const map = /* @__PURE__ */ new Map();
      for (const key of this.getKeys()) {
        map.set(key, this.getValue(key));
      }
      return map;
    }
  };
  var defaultHooks = {
    afterGetValue: ({ value }) => ({ value }),
    beforeSetValue: ({ key, value }) => ({ key, value })
  };
  var parserHooks = {
    afterGetValue: ({ value }) => {
      try {
        value = JSON.parse(value);
      } catch {
        return { value };
      }
      return { value };
    },
    beforeSetValue: ({ key, value }) => {
      value = JSON.stringify(value);
      return { key, value };
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/helpers/patch.js
  var PatchHelper = class extends BasicTool {
    options;
    constructor() {
      super();
      this.options = void 0;
    }
    setData(options) {
      this.options = options;
      const Zotero2 = this.getGlobal("Zotero");
      const { target, funcSign, patcher } = options;
      const origin = target[funcSign];
      this.log("patching ", funcSign);
      target[funcSign] = function(...args) {
        if (options.enabled)
          try {
            return patcher(origin).apply(this, args);
          } catch (e) {
            Zotero2.logError(e);
          }
        return origin.apply(this, args);
      };
      return this;
    }
    enable() {
      if (!this.options)
        throw new Error("No patch data set");
      this.options.enabled = true;
      return this;
    }
    disable() {
      if (!this.options)
        throw new Error("No patch data set");
      this.options.enabled = false;
      return this;
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/helpers/progressWindow.js
  var icons = {
    success: "chrome://zotero/skin/tick.png",
    fail: "chrome://zotero/skin/cross.png"
  };
  var ProgressWindowHelper = class {
    win;
    lines;
    closeTime;
    /**
     *
     * @param header window header
     * @param options
     * @param options.window
     * @param options.closeOnClick
     * @param options.closeTime
     * @param options.closeOtherProgressWindows
     */
    constructor(header, options = {
      closeOnClick: true,
      closeTime: 5e3
    }) {
      this.win = new (BasicTool.getZotero()).ProgressWindow(options);
      this.lines = [];
      this.closeTime = options.closeTime || 5e3;
      this.win.changeHeadline(header);
      if (options.closeOtherProgressWindows) {
        BasicTool.getZotero().ProgressWindowSet.closeAll();
      }
    }
    /**
     * Create a new line
     * @param options
     * @param options.type
     * @param options.icon
     * @param options.text
     * @param options.progress
     * @param options.idx
     */
    createLine(options) {
      const icon = this.getIcon(options.type, options.icon);
      const line = new this.win.ItemProgress(icon || "", options.text || "");
      if (typeof options.progress === "number") {
        line.setProgress(options.progress);
      }
      this.lines.push(line);
      this.updateIcons();
      return this;
    }
    /**
     * Change the line content
     * @param options
     * @param options.type
     * @param options.icon
     * @param options.text
     * @param options.progress
     * @param options.idx
     */
    changeLine(options) {
      if (this.lines?.length === 0) {
        return this;
      }
      const idx = typeof options.idx !== "undefined" && options.idx >= 0 && options.idx < this.lines.length ? options.idx : 0;
      const icon = this.getIcon(options.type, options.icon);
      if (icon) {
        this.lines[idx].setItemTypeAndIcon(icon);
      }
      options.text && this.lines[idx].setText(options.text);
      typeof options.progress === "number" && this.lines[idx].setProgress(options.progress);
      this.updateIcons();
      return this;
    }
    show(closeTime = void 0) {
      this.win.show();
      typeof closeTime !== "undefined" && (this.closeTime = closeTime);
      if (this.closeTime && this.closeTime > 0) {
        this.win.startCloseTimer(this.closeTime);
      }
      setTimeout(this.updateIcons.bind(this), 50);
      return this;
    }
    /**
     * Set custom icon uri for progress window
     * @param key
     * @param uri
     */
    static setIconURI(key, uri) {
      icons[key] = uri;
    }
    getIcon(type, defaultIcon) {
      return type && type in icons ? icons[type] : defaultIcon;
    }
    updateIcons() {
      try {
        this.lines.forEach((line) => {
          const box = line._image;
          const icon = box.dataset.itemType;
          if (icon && !box.style.backgroundImage.includes("progress_arcs")) {
            box.style.backgroundImage = `url(${box.dataset.itemType})`;
          }
        });
      } catch {
      }
    }
    changeHeadline(text, icon, postText) {
      this.win.changeHeadline(text, icon, postText);
      return this;
    }
    addLines(labels, icons2) {
      this.win.addLines(labels, icons2);
      return this;
    }
    addDescription(text) {
      this.win.addDescription(text);
      return this;
    }
    startCloseTimer(ms, requireMouseOver) {
      this.win.startCloseTimer(ms, requireMouseOver);
      return this;
    }
    close() {
      this.win.close();
      return this;
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/helpers/virtualizedTable.js
  var VirtualizedTableHelper = class extends BasicTool {
    props;
    localeStrings;
    containerId;
    treeInstance;
    window;
    React;
    ReactDOM;
    VirtualizedTable;
    IntlProvider;
    constructor(win) {
      super();
      this.window = win;
      const Zotero2 = this.getGlobal("Zotero");
      const _require = win.require;
      this.React = _require("react");
      this.ReactDOM = _require("react-dom");
      this.VirtualizedTable = _require("components/virtualized-table");
      this.IntlProvider = _require("react-intl").IntlProvider;
      this.props = {
        id: `vtable-${Zotero2.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`,
        getRowCount: () => 0
      };
      this.localeStrings = Zotero2.Intl.strings;
    }
    setProp(...args) {
      if (args.length === 1) {
        Object.assign(this.props, args[0]);
      } else if (args.length === 2) {
        this.props[args[0]] = args[1];
      }
      return this;
    }
    /**
     * Set locale strings, which replaces the table header's label if matches. Default it's `Zotero.Intl.strings`
     * @param localeStrings
     */
    setLocale(localeStrings) {
      Object.assign(this.localeStrings, localeStrings);
      return this;
    }
    /**
     * Set container element id that the table will be rendered on.
     * @param id element id
     */
    setContainerId(id) {
      this.containerId = id;
      return this;
    }
    /**
     * Render the table.
     * @param selectId Which row to select after rendering
     * @param onfulfilled callback after successfully rendered
     * @param onrejected callback after rendering with error
     */
    render(selectId, onfulfilled, onrejected) {
      const refreshSelection = () => {
        this.treeInstance.invalidate();
        if (typeof selectId !== "undefined" && selectId >= 0) {
          this.treeInstance.selection.select(selectId);
        } else {
          this.treeInstance.selection.clearSelection();
        }
      };
      if (!this.treeInstance) {
        new Promise((resolve) => {
          const vtableProps = Object.assign({}, this.props, {
            ref: (ref) => {
              this.treeInstance = ref;
              resolve(void 0);
            }
          });
          if (vtableProps.getRowData && !vtableProps.renderItem) {
            Object.assign(vtableProps, {
              renderItem: this.VirtualizedTable.makeRowRenderer(vtableProps.getRowData)
            });
          }
          const elem = this.React.createElement(this.IntlProvider, { locale: Zotero.locale, messages: Zotero.Intl.strings }, this.React.createElement(this.VirtualizedTable, vtableProps));
          const container = this.window.document.getElementById(this.containerId);
          this.ReactDOM.createRoot(container).render(elem);
        }).then(() => {
          this.getGlobal("setTimeout")(() => {
            refreshSelection();
          });
        }).then(onfulfilled, onrejected);
      } else {
        refreshSelection();
      }
      return this;
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/managers/fieldHook.js
  var FieldHookManager = class extends ManagerTool {
    data = {
      getField: {},
      setField: {},
      isFieldOfBase: {}
    };
    patchHelpers = {
      getField: new PatchHelper(),
      setField: new PatchHelper(),
      isFieldOfBase: new PatchHelper()
    };
    constructor(base) {
      super(base);
      const _thisHelper = this;
      for (const type of Object.keys(this.patchHelpers)) {
        const helper = this.patchHelpers[type];
        helper.setData({
          target: this.getGlobal("Zotero").Item.prototype,
          funcSign: type,
          patcher: (original) => function(field, ...args) {
            const originalThis = this;
            const handler = _thisHelper.data[type][field];
            if (typeof handler === "function") {
              try {
                return handler(field, args[0], args[1], originalThis, original);
              } catch (e) {
                return field + String(e);
              }
            }
            return original.apply(originalThis, [field, ...args]);
          },
          enabled: true
        });
      }
    }
    register(type, field, hook) {
      this.data[type][field] = hook;
    }
    unregister(type, field) {
      delete this.data[type][field];
    }
    unregisterAll() {
      this.data.getField = {};
      this.data.setField = {};
      this.data.isFieldOfBase = {};
      this.patchHelpers.getField.disable();
      this.patchHelpers.setField.disable();
      this.patchHelpers.isFieldOfBase.disable();
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/utils/wait.js
  var basicTool = new BasicTool();
  function waitUntil(condition, callback, interval = 100, timeout = 1e4) {
    const start = Date.now();
    const intervalId = basicTool.getGlobal("setInterval")(() => {
      if (condition()) {
        basicTool.getGlobal("clearInterval")(intervalId);
        callback();
      } else if (Date.now() - start > timeout) {
        basicTool.getGlobal("clearInterval")(intervalId);
      }
    }, interval);
  }
  var waitUtilAsync = waitUntilAsync;
  function waitUntilAsync(condition, interval = 100, timeout = 1e4) {
    return new Promise((resolve, reject) => {
      const start = Date.now();
      const intervalId = basicTool.getGlobal("setInterval")(() => {
        if (condition()) {
          basicTool.getGlobal("clearInterval")(intervalId);
          resolve();
        } else if (Date.now() - start > timeout) {
          basicTool.getGlobal("clearInterval")(intervalId);
          reject(new Error("timeout"));
        }
      }, interval);
    });
  }
  async function waitForReader(reader) {
    await reader._initPromise;
    await reader._lastView.initializedPromise;
    if (reader.type === "pdf")
      await reader._lastView._iframeWindow.PDFViewerApplication.initializedPromise;
  }

  // node_modules/zotero-plugin-toolkit/dist/managers/keyboard.js
  var KeyboardManager = class extends ManagerTool {
    _keyboardCallbacks = /* @__PURE__ */ new Set();
    _cachedKey;
    id;
    constructor(base) {
      super(base);
      this.id = `kbd-${Zotero.Utilities.randomString()}`;
      this._ensureAutoUnregisterAll();
      this.addListenerCallback("onMainWindowLoad", this.initKeyboardListener);
      this.addListenerCallback("onMainWindowUnload", this.unInitKeyboardListener);
      this.initReaderKeyboardListener();
      for (const win of Zotero.getMainWindows()) {
        this.initKeyboardListener(win);
      }
    }
    /**
     * Register a keyboard event listener.
     * @param callback The callback function.
     */
    register(callback) {
      this._keyboardCallbacks.add(callback);
    }
    /**
     * Unregister a keyboard event listener.
     * @param callback The callback function.
     */
    unregister(callback) {
      this._keyboardCallbacks.delete(callback);
    }
    /**
     * Unregister all keyboard event listeners.
     */
    unregisterAll() {
      this._keyboardCallbacks.clear();
      this.removeListenerCallback("onMainWindowLoad", this.initKeyboardListener);
      this.removeListenerCallback("onMainWindowUnload", this.unInitKeyboardListener);
      for (const win of Zotero.getMainWindows()) {
        this.unInitKeyboardListener(win);
      }
    }
    initKeyboardListener = this._initKeyboardListener.bind(this);
    unInitKeyboardListener = this._unInitKeyboardListener.bind(this);
    initReaderKeyboardListener() {
      Zotero.Reader.registerEventListener("renderToolbar", (event) => this.addReaderKeyboardCallback(event), this._basicOptions.api.pluginID);
      Zotero.Reader._readers.forEach((reader) => this.addReaderKeyboardCallback({ reader }));
    }
    async addReaderKeyboardCallback(event) {
      const reader = event.reader;
      const initializedKey = `_ztoolkitKeyboard${this.id}Initialized`;
      await waitForReader(reader);
      if (!reader._iframeWindow) {
        return;
      }
      if (reader._iframeWindow[initializedKey]) {
        return;
      }
      this._initKeyboardListener(reader._iframeWindow);
      waitUntil(() => !Components.utils.isDeadWrapper(reader._internalReader) && reader._internalReader?._primaryView?._iframeWindow, () => this._initKeyboardListener(reader._internalReader._primaryView?._iframeWindow));
      reader._iframeWindow[initializedKey] = true;
    }
    _initKeyboardListener(win) {
      if (!win) {
        return;
      }
      win.addEventListener("keydown", this.triggerKeydown);
      win.addEventListener("keyup", this.triggerKeyup);
    }
    _unInitKeyboardListener(win) {
      if (!win) {
        return;
      }
      win.removeEventListener("keydown", this.triggerKeydown);
      win.removeEventListener("keyup", this.triggerKeyup);
    }
    triggerKeydown = (e) => {
      if (!this._cachedKey) {
        this._cachedKey = new KeyModifier(e);
      } else {
        this._cachedKey.merge(new KeyModifier(e), { allowOverwrite: false });
      }
      this.dispatchCallback(e, {
        type: "keydown"
      });
    };
    triggerKeyup = async (e) => {
      if (!this._cachedKey) {
        return;
      }
      const currentShortcut = new KeyModifier(this._cachedKey);
      this._cachedKey = void 0;
      this.dispatchCallback(e, {
        keyboard: currentShortcut,
        type: "keyup"
      });
    };
    dispatchCallback(...args) {
      this._keyboardCallbacks.forEach((cbk) => cbk(...args));
    }
  };
  var KeyModifier = class _KeyModifier {
    accel = false;
    shift = false;
    control = false;
    meta = false;
    alt = false;
    key = "";
    useAccel = false;
    constructor(raw, options) {
      this.useAccel = options?.useAccel || false;
      if (typeof raw === "undefined") {
      } else if (typeof raw === "string") {
        raw = raw || "";
        raw = this.unLocalized(raw);
        this.accel = raw.includes("accel");
        this.shift = raw.includes("shift");
        this.control = raw.includes("control");
        this.meta = raw.includes("meta");
        this.alt = raw.includes("alt");
        this.key = raw.replace(/(accel|shift|control|meta|alt|[ ,\-])/g, "").toLocaleLowerCase();
      } else if (raw instanceof _KeyModifier) {
        this.merge(raw, { allowOverwrite: true });
      } else {
        if (options?.useAccel) {
          if (Zotero.isMac) {
            this.accel = raw.metaKey;
          } else {
            this.accel = raw.ctrlKey;
          }
        }
        this.shift = raw.shiftKey;
        this.control = raw.ctrlKey;
        this.meta = raw.metaKey;
        this.alt = raw.altKey;
        if (!["Shift", "Meta", "Ctrl", "Alt", "Control"].includes(raw.key)) {
          this.key = raw.key;
        }
      }
    }
    /**
     * Merge another KeyModifier into this one.
     * @param newMod the new KeyModifier
     * @param options
     * @param options.allowOverwrite
     * @returns KeyModifier
     */
    merge(newMod, options) {
      const allowOverwrite = options?.allowOverwrite || false;
      this.mergeAttribute("accel", newMod.accel, allowOverwrite);
      this.mergeAttribute("shift", newMod.shift, allowOverwrite);
      this.mergeAttribute("control", newMod.control, allowOverwrite);
      this.mergeAttribute("meta", newMod.meta, allowOverwrite);
      this.mergeAttribute("alt", newMod.alt, allowOverwrite);
      this.mergeAttribute("key", newMod.key, allowOverwrite);
      return this;
    }
    /**
     * Check if the current KeyModifier equals to another KeyModifier.
     * @param newMod the new KeyModifier
     * @returns true if equals
     */
    equals(newMod) {
      if (typeof newMod === "string") {
        newMod = new _KeyModifier(newMod);
      }
      if (this.shift !== newMod.shift || this.alt !== newMod.alt || this.key.toLowerCase() !== newMod.key.toLowerCase()) {
        return false;
      }
      if (this.accel || newMod.accel) {
        if (Zotero.isMac) {
          if ((this.accel || this.meta) !== (newMod.accel || newMod.meta) || this.control !== newMod.control) {
            return false;
          }
        } else {
          if ((this.accel || this.control) !== (newMod.accel || newMod.control) || this.meta !== newMod.meta) {
            return false;
          }
        }
      } else {
        if (this.control !== newMod.control || this.meta !== newMod.meta) {
          return false;
        }
      }
      return true;
    }
    /**
     * Get the raw string representation of the KeyModifier.
     */
    getRaw() {
      const enabled = [];
      this.accel && enabled.push("accel");
      this.shift && enabled.push("shift");
      this.control && enabled.push("control");
      this.meta && enabled.push("meta");
      this.alt && enabled.push("alt");
      this.key && enabled.push(this.key);
      return enabled.join(",");
    }
    /**
     * Get the localized string representation of the KeyModifier.
     */
    getLocalized() {
      const raw = this.getRaw();
      if (Zotero.isMac) {
        return raw.replaceAll("control", "\u2303").replaceAll("alt", "\u2325").replaceAll("shift", "\u21E7").replaceAll("meta", "\u2318");
      } else {
        return raw.replaceAll("control", "Ctrl").replaceAll("alt", "Alt").replaceAll("shift", "Shift").replaceAll("meta", "Win");
      }
    }
    /**
     * Get the un-localized string representation of the KeyModifier.
     */
    unLocalized(raw) {
      if (Zotero.isMac) {
        return raw.replaceAll("\u2303", "control").replaceAll("\u2325", "alt").replaceAll("\u21E7", "shift").replaceAll("\u2318", "meta");
      } else {
        return raw.replaceAll("Ctrl", "control").replaceAll("Alt", "alt").replaceAll("Shift", "shift").replaceAll("Win", "meta");
      }
    }
    mergeAttribute(attribute, value, allowOverwrite) {
      if (allowOverwrite || !this[attribute]) {
        this[attribute] = value;
      }
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/managers/menu.js
  var MenuManager = class extends ManagerTool {
    ui;
    constructor(base) {
      super(base);
      this.ui = new UITool(this);
    }
    /**
     * Insert an menu item/menu(with popup)/menuseprator into a menupopup
     * @remarks
     * options:
     * ```ts
     * export interface MenuitemOptions {
     *   tag: "menuitem" | "menu" | "menuseparator";
     *   id?: string;
     *   label?: string;
     *   // data url (chrome://xxx.png) or base64 url (data:image/png;base64,xxx)
     *   icon?: string;
     *   class?: string;
     *   styles?: { [key: string]: string };
     *   hidden?: boolean;
     *   disabled?: boolean;
     *   oncommand?: string;
     *   commandListener?: EventListenerOrEventListenerObject;
     *   // Attributes below are used when type === "menu"
     *   popupId?: string;
     *   onpopupshowing?: string;
     *   subElementOptions?: Array<MenuitemOptions>;
     * }
     * ```
     * @param menuPopup
     * @param options
     * @param insertPosition
     * @param anchorElement The menuitem will be put before/after `anchorElement`. If not set, put at start/end of the menupopup.
     * @example
     * Insert menuitem with icon into item menupopup
     * ```ts
     * // base64 or chrome:// url
     * const menuIcon = "chrome://addontemplate/content/icons/favicon@0.5x.png";
     * ztoolkit.Menu.register("item", {
     *   tag: "menuitem",
     *   id: "zotero-itemmenu-addontemplate-test",
     *   label: "Addon Template: Menuitem",
     *   oncommand: "alert('Hello World! Default Menuitem.')",
     *   icon: menuIcon,
     * });
     * ```
     * @example
     * Insert menu into file menupopup
     * ```ts
     * ztoolkit.Menu.register(
     *   "menuFile",
     *   {
     *     tag: "menu",
     *     label: "Addon Template: Menupopup",
     *     subElementOptions: [
     *       {
     *         tag: "menuitem",
     *         label: "Addon Template",
     *         oncommand: "alert('Hello World! Sub Menuitem.')",
     *       },
     *     ],
     *   },
     *   "before",
     *   Zotero.getMainWindow().document.querySelector(
     *     "#zotero-itemmenu-addontemplate-test"
     *   )
     * );
     * ```
     */
    register(menuPopup, options, insertPosition = "after", anchorElement) {
      let popup;
      if (typeof menuPopup === "string") {
        popup = this.getGlobal("document").querySelector(MenuSelector[menuPopup]);
      } else {
        popup = menuPopup;
      }
      if (!popup) {
        return false;
      }
      const doc = popup.ownerDocument;
      const genMenuElement = (menuitemOption) => {
        const elementOption = {
          tag: menuitemOption.tag,
          id: menuitemOption.id,
          namespace: "xul",
          attributes: {
            label: menuitemOption.label || "",
            hidden: Boolean(menuitemOption.hidden),
            disabled: Boolean(menuitemOption.disabled),
            class: menuitemOption.class || "",
            oncommand: menuitemOption.oncommand || ""
          },
          classList: menuitemOption.classList,
          styles: menuitemOption.styles || {},
          listeners: [],
          children: []
        };
        if (menuitemOption.icon) {
          if (!this.getGlobal("Zotero").isMac) {
            if (menuitemOption.tag === "menu") {
              elementOption.attributes.class += " menu-iconic";
            } else {
              elementOption.attributes.class += " menuitem-iconic";
            }
          }
          elementOption.styles["list-style-image"] = `url(${menuitemOption.icon})`;
        }
        if (menuitemOption.commandListener) {
          elementOption.listeners?.push({
            type: "command",
            listener: menuitemOption.commandListener
          });
        }
        if (menuitemOption.tag === "menuitem") {
          elementOption.attributes.type = menuitemOption.type || "";
          elementOption.attributes.checked = menuitemOption.checked || false;
        }
        const menuItem = this.ui.createElement(doc, menuitemOption.tag, elementOption);
        if (menuitemOption.isHidden || menuitemOption.getVisibility) {
          popup?.addEventListener("popupshowing", (ev) => {
            let hidden;
            if (menuitemOption.isHidden) {
              hidden = menuitemOption.isHidden(menuItem, ev);
            } else if (menuitemOption.getVisibility) {
              const visible = menuitemOption.getVisibility(menuItem, ev);
              hidden = typeof visible === "undefined" ? void 0 : !visible;
            }
            if (typeof hidden === "undefined") {
              return;
            }
            if (hidden) {
              menuItem.setAttribute("hidden", "true");
            } else {
              menuItem.removeAttribute("hidden");
            }
          });
        }
        if (menuitemOption.isDisabled) {
          popup?.addEventListener("popupshowing", (ev) => {
            const disabled = menuitemOption.isDisabled(menuItem, ev);
            if (typeof disabled === "undefined") {
              return;
            }
            if (disabled) {
              menuItem.setAttribute("disabled", "true");
            } else {
              menuItem.removeAttribute("disabled");
            }
          });
        }
        if ((menuitemOption.tag === "menuitem" || menuitemOption.tag === "menuseparator") && menuitemOption.onShowing) {
          popup?.addEventListener("popupshowing", (ev) => {
            menuitemOption.onShowing(menuItem, ev);
          });
        }
        if (menuitemOption.tag === "menu") {
          const subPopup = this.ui.createElement(doc, "menupopup", {
            id: menuitemOption.popupId,
            attributes: { onpopupshowing: menuitemOption.onpopupshowing || "" }
          });
          menuitemOption.children?.forEach((childOption) => {
            subPopup.append(genMenuElement(childOption));
          });
          menuItem.append(subPopup);
        }
        return menuItem;
      };
      const topMenuItem = genMenuElement(options);
      if (popup.childElementCount) {
        if (!anchorElement) {
          anchorElement = insertPosition === "after" ? popup.lastElementChild : popup.firstElementChild;
        }
        anchorElement[insertPosition](topMenuItem);
      } else {
        popup.appendChild(topMenuItem);
      }
    }
    unregister(menuId) {
      this.getGlobal("document").querySelector(`#${menuId}`)?.remove();
    }
    unregisterAll() {
      this.ui.unregisterAll();
    }
  };
  var MenuSelector;
  (function(MenuSelector2) {
    MenuSelector2["menuFile"] = "#menu_FilePopup";
    MenuSelector2["menuEdit"] = "#menu_EditPopup";
    MenuSelector2["menuView"] = "#menu_viewPopup";
    MenuSelector2["menuGo"] = "#menu_goPopup";
    MenuSelector2["menuTools"] = "#menu_ToolsPopup";
    MenuSelector2["menuHelp"] = "#menu_HelpPopup";
    MenuSelector2["collection"] = "#zotero-collectionmenu";
    MenuSelector2["item"] = "#zotero-itemmenu";
  })(MenuSelector || (MenuSelector = {}));

  // node_modules/zotero-plugin-toolkit/dist/managers/prompt.js
  var Prompt = class {
    ui;
    base;
    get document() {
      return this.base.getGlobal("document");
    }
    /**
     * Record the last text entered
     */
    lastInputText = "";
    /**
     * Default text
     */
    defaultText = {
      placeholder: "Select a command...",
      empty: "No commands found."
    };
    /**
     * It controls the max line number of commands displayed in `commandsNode`.
     */
    maxLineNum = 12;
    /**
     * It controls the max number of suggestions.
     */
    maxSuggestionNum = 100;
    /**
     * The top-level HTML div node of `Prompt`
     */
    promptNode;
    /**
     * The HTML input node of `Prompt`.
     */
    inputNode;
    /**
     * Save all commands registered by all addons.
     */
    commands = [];
    /**
     * Initialize `Prompt` but do not create UI.
     */
    constructor() {
      this.base = new BasicTool();
      this.ui = new UITool();
      this.initializeUI();
    }
    /**
     * Initialize `Prompt` UI and then bind events on it.
     */
    initializeUI() {
      this.addStyle();
      this.createHTML();
      this.initInputEvents();
      this.registerShortcut();
    }
    createHTML() {
      this.promptNode = this.ui.createElement(this.document, "div", {
        styles: {
          display: "none"
        },
        children: [
          {
            tag: "div",
            styles: {
              position: "fixed",
              left: "0",
              top: "0",
              backgroundColor: "transparent",
              width: "100%",
              height: "100%"
            },
            listeners: [
              {
                type: "click",
                listener: () => {
                  this.promptNode.style.display = "none";
                }
              }
            ]
          }
        ]
      });
      this.promptNode.appendChild(this.ui.createElement(this.document, "div", {
        id: `zotero-plugin-toolkit-prompt`,
        classList: ["prompt-container"],
        children: [
          {
            tag: "div",
            classList: ["input-container"],
            children: [
              {
                tag: "input",
                classList: ["prompt-input"],
                attributes: {
                  type: "text",
                  placeholder: this.defaultText.placeholder
                }
              },
              {
                tag: "div",
                classList: ["cta"]
              }
            ]
          },
          {
            tag: "div",
            classList: ["commands-containers"]
          },
          {
            tag: "div",
            classList: ["instructions"],
            children: [
              {
                tag: "div",
                classList: ["instruction"],
                children: [
                  {
                    tag: "span",
                    classList: ["key"],
                    properties: {
                      innerText: "\u2191\u2193"
                    }
                  },
                  {
                    tag: "span",
                    properties: {
                      innerText: "to navigate"
                    }
                  }
                ]
              },
              {
                tag: "div",
                classList: ["instruction"],
                children: [
                  {
                    tag: "span",
                    classList: ["key"],
                    properties: {
                      innerText: "enter"
                    }
                  },
                  {
                    tag: "span",
                    properties: {
                      innerText: "to trigger"
                    }
                  }
                ]
              },
              {
                tag: "div",
                classList: ["instruction"],
                children: [
                  {
                    tag: "span",
                    classList: ["key"],
                    properties: {
                      innerText: "esc"
                    }
                  },
                  {
                    tag: "span",
                    properties: {
                      innerText: "to exit"
                    }
                  }
                ]
              }
            ]
          }
        ]
      }));
      this.inputNode = this.promptNode.querySelector("input");
      this.document.documentElement.appendChild(this.promptNode);
    }
    /**
     * Show commands in a new `commandsContainer`
     * All other `commandsContainer` is hidden
     * @param commands Command[]
     * @param clear remove all `commandsContainer` if true
     */
    showCommands(commands, clear = false) {
      if (clear) {
        this.promptNode.querySelectorAll(".commands-container").forEach((e) => e.remove());
      }
      this.inputNode.placeholder = this.defaultText.placeholder;
      const commandsContainer = this.createCommandsContainer();
      for (const command of commands) {
        try {
          if (!command.name || command.when && !command.when()) {
            continue;
          }
        } catch {
          continue;
        }
        commandsContainer.appendChild(this.createCommandNode(command));
      }
    }
    /**
     * Create a `commandsContainer` div element, append to `commandsContainer` and hide others.
     * @returns commandsNode
     */
    createCommandsContainer() {
      const commandsContainer = this.ui.createElement(this.document, "div", {
        classList: ["commands-container"]
      });
      this.promptNode.querySelectorAll(".commands-container").forEach((e) => {
        e.style.display = "none";
      });
      this.promptNode.querySelector(".commands-containers").appendChild(commandsContainer);
      return commandsContainer;
    }
    /**
     * Return current displayed `commandsContainer`
     * @returns
     */
    getCommandsContainer() {
      return [
        ...Array.from(this.promptNode.querySelectorAll(".commands-container"))
      ].find((e) => {
        return e.style.display !== "none";
      });
    }
    /**
     * Create a command item for `Prompt` UI.
     * @param command
     * @returns
     */
    createCommandNode(command) {
      const commandNode = this.ui.createElement(this.document, "div", {
        classList: ["command"],
        children: [
          {
            tag: "div",
            classList: ["content"],
            children: [
              {
                tag: "div",
                classList: ["name"],
                children: [
                  {
                    tag: "span",
                    properties: {
                      innerText: command.name
                    }
                  }
                ]
              },
              {
                tag: "div",
                classList: ["aux"],
                children: command.label ? [
                  {
                    tag: "span",
                    classList: ["label"],
                    properties: {
                      innerText: command.label
                    }
                  }
                ] : []
              }
            ]
          }
        ],
        listeners: [
          {
            type: "mousemove",
            listener: () => {
              this.selectItem(commandNode);
            }
          },
          {
            type: "click",
            listener: async () => {
              await this.execCallback(command.callback);
            }
          }
        ]
      });
      commandNode.command = command;
      return commandNode;
    }
    /**
     * Called when `enter` key is pressed.
     */
    trigger() {
      [
        ...Array.from(this.promptNode.querySelectorAll(".commands-container"))
      ].find((e) => e.style.display !== "none").querySelector(".selected").click();
    }
    /**
     * Called when `escape` key is pressed.
     */
    exit() {
      this.inputNode.placeholder = this.defaultText.placeholder;
      if (this.promptNode.querySelectorAll(".commands-containers .commands-container").length >= 2) {
        this.promptNode.querySelector(".commands-container:last-child").remove();
        const commandsContainer = this.promptNode.querySelector(".commands-container:last-child");
        commandsContainer.style.display = "";
        commandsContainer.querySelectorAll(".commands").forEach((e) => e.style.display = "flex");
        this.inputNode.focus();
      } else {
        this.promptNode.style.display = "none";
      }
    }
    async execCallback(callback) {
      if (Array.isArray(callback)) {
        this.showCommands(callback);
      } else {
        await callback(this);
      }
    }
    /**
     * Match suggestions for user's entered text.
     */
    async showSuggestions(inputText) {
      const _w = /[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,\-./:;<=>?@[\]^_`{|}~]/;
      const jw = /\s/;
      const Ww = /[\u0F00-\u0FFF\u3040-\u30FF\u3400-\u4DBF\u4E00-\u9FFF\uF900-\uFAFF\uFF66-\uFF9F]/;
      function Yw(e2, t, n, i) {
        if (e2.length === 0)
          return 0;
        let r = 0;
        r -= Math.max(0, e2.length - 1), r -= i / 10;
        const o = e2[0][0];
        return r -= (e2[e2.length - 1][1] - o + 1 - t) / 100, r -= o / 1e3, r -= n / 1e4;
      }
      function $w(e2, t, n, i) {
        if (e2.length === 0)
          return null;
        for (var r = n.toLowerCase(), o = 0, a = 0, s = [], l = 0; l < e2.length; l++) {
          const c = e2[l];
          const u = r.indexOf(c, a);
          if (u === -1)
            return null;
          const h = n.charAt(u);
          if (u > 0 && !_w.test(h) && !Ww.test(h)) {
            const p = n.charAt(u - 1);
            if (h.toLowerCase() !== h && p.toLowerCase() !== p || h.toUpperCase() !== h && !_w.test(p) && !jw.test(p) && !Ww.test(p))
              if (i) {
                if (u !== a) {
                  a += c.length, l--;
                  continue;
                }
              } else
                o += 1;
          }
          if (s.length === 0)
            s.push([u, u + c.length]);
          else {
            const d = s[s.length - 1];
            d[1] < u ? s.push([u, u + c.length]) : d[1] = u + c.length;
          }
          a = u + c.length;
        }
        return {
          matches: s,
          score: Yw(s, t.length, r.length, o)
        };
      }
      function Gw(e2) {
        for (var t = e2.toLowerCase(), n = [], i = 0, r = 0; r < t.length; r++) {
          const o = t.charAt(r);
          jw.test(o) ? (i !== r && n.push(t.substring(i, r)), i = r + 1) : (_w.test(o) || Ww.test(o)) && (i !== r && n.push(t.substring(i, r)), n.push(o), i = r + 1);
        }
        return i !== t.length && n.push(t.substring(i, t.length)), {
          query: e2,
          tokens: n,
          fuzzy: t.split("")
        };
      }
      function Xw(e2, t) {
        if (e2.query === "")
          return {
            score: 0,
            matches: []
          };
        const n = $w(e2.tokens, e2.query, t, false);
        return n || $w(e2.fuzzy, e2.query, t, true);
      }
      const e = Gw(inputText);
      let container = this.getCommandsContainer();
      if (container.classList.contains("suggestions")) {
        this.exit();
      }
      if (inputText.trim() == "") {
        return true;
      }
      const suggestions = [];
      this.getCommandsContainer().querySelectorAll(".command").forEach((commandNode) => {
        const spanNode = commandNode.querySelector(".name span");
        const spanText = spanNode.innerText;
        const res = Xw(e, spanText);
        if (res) {
          commandNode = this.createCommandNode(commandNode.command);
          let spanHTML = "";
          let i = 0;
          for (let j = 0; j < res.matches.length; j++) {
            const [start, end] = res.matches[j];
            if (start > i) {
              spanHTML += spanText.slice(i, start);
            }
            spanHTML += `<span class="highlight">${spanText.slice(start, end)}</span>`;
            i = end;
          }
          if (i < spanText.length) {
            spanHTML += spanText.slice(i, spanText.length);
          }
          commandNode.querySelector(".name span").innerHTML = spanHTML;
          suggestions.push({ score: res.score, commandNode });
        }
      });
      if (suggestions.length > 0) {
        suggestions.sort((a, b) => b.score - a.score).slice(this.maxSuggestionNum);
        container = this.createCommandsContainer();
        container.classList.add("suggestions");
        suggestions.forEach((suggestion) => {
          container.appendChild(suggestion.commandNode);
        });
        return true;
      } else {
        const anonymousCommand = this.commands.find((c) => !c.name && (!c.when || c.when()));
        if (anonymousCommand) {
          await this.execCallback(anonymousCommand.callback);
        } else {
          this.showTip(this.defaultText.empty);
        }
        return false;
      }
    }
    /**
     * Bind events of pressing `keydown` and `keyup` key.
     */
    initInputEvents() {
      this.promptNode.addEventListener("keydown", (event) => {
        if (["ArrowUp", "ArrowDown"].includes(event.key)) {
          event.preventDefault();
          let selectedIndex;
          const allItems = [
            ...Array.from(this.getCommandsContainer().querySelectorAll(".command"))
          ].filter((e) => e.style.display != "none");
          selectedIndex = allItems.findIndex((e) => e.classList.contains("selected"));
          if (selectedIndex != -1) {
            allItems[selectedIndex].classList.remove("selected");
            selectedIndex += event.key == "ArrowUp" ? -1 : 1;
          } else {
            if (event.key == "ArrowUp") {
              selectedIndex = allItems.length - 1;
            } else {
              selectedIndex = 0;
            }
          }
          if (selectedIndex == -1) {
            selectedIndex = allItems.length - 1;
          } else if (selectedIndex == allItems.length) {
            selectedIndex = 0;
          }
          allItems[selectedIndex].classList.add("selected");
          const commandsContainer = this.getCommandsContainer();
          commandsContainer.scrollTo(0, commandsContainer.querySelector(".selected").offsetTop - commandsContainer.offsetHeight + 7.5);
          allItems[selectedIndex].classList.add("selected");
        }
      });
      this.promptNode.addEventListener("keyup", async (event) => {
        if (event.key == "Enter") {
          this.trigger();
        } else if (event.key == "Escape") {
          if (this.inputNode.value.length > 0) {
            this.inputNode.value = "";
          } else {
            this.exit();
          }
        } else if (["ArrowUp", "ArrowDown"].includes(event.key)) {
          return;
        }
        const currentInputText = this.inputNode.value;
        if (currentInputText == this.lastInputText) {
          return;
        }
        this.lastInputText = currentInputText;
        window.setTimeout(async () => {
          await this.showSuggestions(currentInputText);
        });
      });
    }
    /**
     * Create a commandsContainer and display a text
     */
    showTip(text) {
      const tipNode = this.ui.createElement(this.document, "div", {
        classList: ["tip"],
        properties: {
          innerText: text
        }
      });
      const container = this.createCommandsContainer();
      container.classList.add("suggestions");
      container.appendChild(tipNode);
      return tipNode;
    }
    /**
     * Mark the selected item with class `selected`.
     * @param item HTMLDivElement
     */
    selectItem(item) {
      this.getCommandsContainer().querySelectorAll(".command").forEach((e) => e.classList.remove("selected"));
      item.classList.add("selected");
    }
    addStyle() {
      const style2 = this.ui.createElement(this.document, "style", {
        namespace: "html",
        id: "prompt-style"
      });
      style2.innerText = `
      .prompt-container * {
        box-sizing: border-box;
      }
      .prompt-container {
        ---radius---: 10px;
        position: fixed;
        left: 25%;
        top: 10%;
        width: 50%;
        border-radius: var(---radius---);
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        font-size: 18px;
        box-shadow: 0px 1.8px 7.3px rgba(0, 0, 0, 0.071),
                    0px 6.3px 24.7px rgba(0, 0, 0, 0.112),
                    0px 30px 90px rgba(0, 0, 0, 0.2);
        font-family: ui-sans-serif, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Inter", "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Microsoft YaHei Light", sans-serif;
        background-color: var(--material-background) !important;
        border: var(--material-border-quarternary) !important;
      }
      
      /* input */
      .prompt-container .input-container  {
        width: 100%;
      }

      .input-container input {
        width: -moz-available;
        height: 40px;
        padding: 24px;
        border: none;
        outline: none;
        font-size: 18px;
        margin: 0 !important;
        border-radius: var(---radius---);
        background-color: var(--material-background);
      }
      
      .input-container .cta {
        border-bottom: var(--material-border-quarternary);
        margin: 5px auto;
      }
      
      /* results */
      .commands-containers {
        width: 100%;
        height: 100%;
      }
      .commands-container {
        max-height: calc(${this.maxLineNum} * 35.5px);
        width: calc(100% - 12px);
        margin-left: 12px;
        margin-right: 0%;
        overflow-y: auto;
        overflow-x: hidden;
      }
      
      .commands-container .command {
        display: flex;
        align-content: baseline;
        justify-content: space-between;
        border-radius: 5px;
        padding: 6px 12px;
        margin-right: 12px;
        margin-top: 2px;
        margin-bottom: 2px;
      }
      .commands-container .command .content {
        display: flex;
        width: 100%;
        justify-content: space-between;
        flex-direction: row;
        overflow: hidden;
      }
      .commands-container .command .content .name {
        white-space: nowrap; 
        text-overflow: ellipsis;
        overflow: hidden;
      }
      .commands-container .command .content .aux {
        display: flex;
        align-items: center;
        align-self: center;
        flex-shrink: 0;
      }
      
      .commands-container .command .content .aux .label {
        font-size: 15px;
        color: var(--fill-primary);
        padding: 2px 6px;
        background-color: var(--color-background);
        border-radius: 5px;
      }
      
      .commands-container .selected {
          background-color: var(--material-mix-quinary);
      }

      .commands-container .highlight {
        font-weight: bold;
      }

      .tip {
        color: var(--fill-primary);
        text-align: center;
        padding: 12px 12px;
        font-size: 18px;
      }

      /* instructions */
      .instructions {
        display: flex;
        align-content: center;
        justify-content: center;
        font-size: 15px;
        height: 2.5em;
        width: 100%;
        border-top: var(--material-border-quarternary);
        color: var(--fill-secondary);
        margin-top: 5px;
      }
      
      .instructions .instruction {
        margin: auto .5em;  
      }
      
      .instructions .key {
        margin-right: .2em;
        font-weight: 600;
      }
    `;
      this.document.documentElement.appendChild(style2);
    }
    registerShortcut() {
      this.document.addEventListener("keydown", (event) => {
        if (event.shiftKey && event.key.toLowerCase() == "p") {
          if (event.originalTarget.isContentEditable || "value" in event.originalTarget || this.commands.length == 0) {
            return;
          }
          event.preventDefault();
          event.stopPropagation();
          if (this.promptNode.style.display == "none") {
            this.promptNode.style.display = "flex";
            if (this.promptNode.querySelectorAll(".commands-container").length == 1) {
              this.showCommands(this.commands, true);
            }
            this.promptNode.focus();
            this.inputNode.focus();
          } else {
            this.promptNode.style.display = "none";
          }
        }
      }, true);
    }
  };
  var PromptManager = class extends ManagerTool {
    prompt;
    /**
     * Save the commands registered from this manager
     */
    commands = [];
    constructor(base) {
      super(base);
      const globalCache = toolkitGlobal_default.getInstance()?.prompt;
      if (!globalCache) {
        throw new Error("Prompt is not initialized.");
      }
      if (!globalCache._ready) {
        globalCache._ready = true;
        globalCache.instance = new Prompt();
      }
      this.prompt = globalCache.instance;
    }
    /**
     * Register commands. Don't forget to call `unregister` on plugin exit.
     * @param commands Command[]
     * @example
     * ```ts
     * let getReader = () => {
     *   return BasicTool.getZotero().Reader.getByTabID(
     *     (Zotero.getMainWindow().Zotero_Tabs).selectedID
     *   )
     * }
     *
     * register([
     *   {
     *     name: "Split Horizontally",
     *     label: "Zotero",
     *     when: () => getReader() as boolean,
     *     callback: (prompt: Prompt) => getReader().menuCmd("splitHorizontally")
     *   },
     *   {
     *     name: "Split Vertically",
     *     label: "Zotero",
     *     when: () => getReader() as boolean,
     *     callback: (prompt: Prompt) => getReader().menuCmd("splitVertically")
     *   }
     * ])
     * ```
     */
    register(commands) {
      commands.forEach((c) => c.id ??= c.name);
      this.prompt.commands = [...this.prompt.commands, ...commands];
      this.commands = [...this.commands, ...commands];
      this.prompt.showCommands(this.commands, true);
    }
    /**
     * You can delete a command registed before by its name.
     * @remarks
     * There is a premise here that the names of all commands registered by a single plugin are not duplicated.
     * @param id Command.name
     */
    unregister(id) {
      this.prompt.commands = this.prompt.commands.filter((c) => c.id != id);
      this.commands = this.commands.filter((c) => c.id != id);
    }
    /**
     * Call `unregisterAll` on plugin exit.
     */
    unregisterAll() {
      this.prompt.commands = this.prompt.commands.filter((c) => {
        return this.commands.every((_c) => _c.id != c.id);
      });
      this.commands = [];
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/tools/extraField.js
  var ExtraFieldTool = class extends BasicTool {
    /**
     * Get all extra fields
     * @param item
     */
    getExtraFields(item, backend = "custom") {
      const extraFiledRaw = item.getField("extra");
      if (backend === "default") {
        return this.getGlobal("Zotero").Utilities.Internal.extractExtraFields(extraFiledRaw).fields;
      } else {
        const map = /* @__PURE__ */ new Map();
        const nonStandardFields = [];
        extraFiledRaw.split("\n").forEach((line) => {
          const split = line.split(": ");
          if (split.length >= 2 && split[0]) {
            map.set(split[0], split.slice(1).join(": "));
          } else {
            nonStandardFields.push(line);
          }
        });
        map.set("__nonStandard__", nonStandardFields.join("\n"));
        return map;
      }
    }
    /**
     * Get extra field value by key. If it does not exists, return undefined.
     * @param item
     * @param key
     */
    getExtraField(item, key) {
      const fields = this.getExtraFields(item);
      return fields.get(key);
    }
    /**
     * Replace extra field of an item.
     * @param item
     * @param fields
     */
    async replaceExtraFields(item, fields) {
      const kvs = [];
      if (fields.has("__nonStandard__")) {
        kvs.push(fields.get("__nonStandard__"));
        fields.delete("__nonStandard__");
      }
      fields.forEach((v, k) => {
        kvs.push(`${k}: ${v}`);
      });
      item.setField("extra", kvs.join("\n"));
      await item.saveTx();
    }
    /**
     * Set an key-value pair to the item's extra field
     * @param item
     * @param key
     * @param value
     */
    async setExtraField(item, key, value) {
      const fields = this.getExtraFields(item);
      if (value === "" || typeof value === "undefined") {
        fields.delete(key);
      } else {
        fields.set(key, value);
      }
      await this.replaceExtraFields(item, fields);
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/tools/reader.js
  var ReaderTool = class extends BasicTool {
    /**
     * Get the selected tab reader.
     * @param waitTime Wait for n MS until the reader is ready
     */
    async getReader(waitTime = 5e3) {
      const Zotero_Tabs = this.getGlobal("Zotero_Tabs");
      if (Zotero_Tabs.selectedType !== "reader") {
        return void 0;
      }
      let reader = Zotero.Reader.getByTabID(Zotero_Tabs.selectedID);
      let delayCount = 0;
      const checkPeriod = 50;
      while (!reader && delayCount * checkPeriod < waitTime) {
        await new Promise((resolve) => setTimeout(resolve, checkPeriod));
        reader = Zotero.Reader.getByTabID(Zotero_Tabs.selectedID);
        delayCount++;
      }
      await reader?._initPromise;
      return reader;
    }
    /**
     * Get all window readers.
     */
    getWindowReader() {
      const Zotero_Tabs = this.getGlobal("Zotero_Tabs");
      const windowReaders = [];
      const tabs = Zotero_Tabs._tabs.map((e) => e.id);
      for (let i = 0; i < Zotero.Reader._readers.length; i++) {
        let flag = false;
        for (let j = 0; j < tabs.length; j++) {
          if (Zotero.Reader._readers[i].tabID === tabs[j]) {
            flag = true;
            break;
          }
        }
        if (!flag) {
          windowReaders.push(Zotero.Reader._readers[i]);
        }
      }
      return windowReaders;
    }
    /**
     * Get Reader tabpanel deck element.
     * @deprecated - use item pane api
     * @alpha
     */
    getReaderTabPanelDeck() {
      const deck = this.getGlobal("window").document.querySelector(".notes-pane-deck")?.previousElementSibling;
      return deck;
    }
    /**
     * Add a reader tabpanel deck selection change observer.
     * @deprecated - use item pane api
     * @alpha
     * @param callback
     */
    async addReaderTabPanelDeckObserver(callback) {
      await waitUtilAsync(() => !!this.getReaderTabPanelDeck());
      const deck = this.getReaderTabPanelDeck();
      const observer = new (this.getGlobal("MutationObserver"))(async (mutations) => {
        mutations.forEach(async (mutation) => {
          const target = mutation.target;
          if (target.classList.contains("zotero-view-tabbox") || target.tagName === "deck") {
            callback();
          }
        });
      });
      observer.observe(deck, {
        attributes: true,
        attributeFilter: ["selectedIndex"],
        subtree: true
      });
      return observer;
    }
    /**
     * Get the selected annotation data.
     * @param reader Target reader
     * @returns The selected annotation data.
     */
    getSelectedAnnotationData(reader) {
      const annotation = (
        // @ts-expect-error _selectionPopup
        reader?._internalReader._lastView._selectionPopup?.annotation
      );
      return annotation;
    }
    /**
     * Get the text selection of reader.
     * @param reader Target reader
     * @returns The text selection of reader.
     */
    getSelectedText(reader) {
      return this.getSelectedAnnotationData(reader)?.text ?? "";
    }
  };

  // node_modules/zotero-plugin-toolkit/dist/ztoolkit.js
  var ZoteroToolkit = class extends BasicTool {
    static _version = BasicTool._version;
    UI = new UITool(this);
    Reader = new ReaderTool(this);
    ExtraField = new ExtraFieldTool(this);
    FieldHooks = new FieldHookManager(this);
    Keyboard = new KeyboardManager(this);
    Prompt = new PromptManager(this);
    Menu = new MenuManager(this);
    Clipboard = makeHelperTool(ClipboardHelper, this);
    FilePicker = makeHelperTool(FilePickerHelper, this);
    Patch = makeHelperTool(PatchHelper, this);
    ProgressWindow = makeHelperTool(ProgressWindowHelper, this);
    VirtualizedTable = makeHelperTool(VirtualizedTableHelper, this);
    Dialog = makeHelperTool(DialogHelper, this);
    LargePrefObject = makeHelperTool(LargePrefHelper, this);
    Guide = makeHelperTool(GuideHelper, this);
    constructor() {
      super();
    }
    /**
     * Unregister everything created by managers.
     */
    unregisterAll() {
      unregister(this);
    }
  };

  // package.json
  var version = "0.1.2";
  var config = {
    addonName: "Zotero Sync Vault",
    addonID: "abcamus_dev@163.com",
    addonRef: "zotero-sync-vault",
    addonInstance: "ZoteroSyncVault",
    prefsPrefix: "extensions.zotero.syncvault"
  };

  // src/utils/locale.ts
  function initLocale() {
    const l10n = new (typeof Localization === "undefined" ? ztoolkit.getGlobal("Localization") : Localization)([`${config.addonRef}-addon.ftl`], true);
    addon.data.locale = {
      current: l10n
    };
  }
  function getString(...inputs) {
    if (inputs.length === 1) {
      return _getString(inputs[0]);
    } else if (inputs.length === 2) {
      if (typeof inputs[1] === "string") {
        return _getString(inputs[0], { branch: inputs[1] });
      } else {
        return _getString(inputs[0], inputs[1]);
      }
    } else {
      throw new Error("Invalid arguments");
    }
  }
  function _getString(localeString, options = {}) {
    const localStringWithPrefix = `${config.addonRef}-${localeString}`;
    const { branch, args } = options;
    const pattern = addon.data.locale?.current.formatMessagesSync([
      { id: localStringWithPrefix, args }
    ])[0];
    if (!pattern) {
      return localStringWithPrefix;
    }
    if (branch && pattern.attributes) {
      for (const attr of pattern.attributes) {
        if (attr.name === branch) {
          return attr.value;
        }
      }
      return pattern.attributes[branch] || localStringWithPrefix;
    } else {
      return pattern.value || localStringWithPrefix;
    }
  }

  // typings/sync-vault.ts
  var CloudDiskType = /* @__PURE__ */ ((CloudDiskType2) => {
    CloudDiskType2["Baidu"] = "baidu";
    CloudDiskType2["OneDrive"] = "onedrive";
    CloudDiskType2["Unknown"] = "unknown";
    return CloudDiskType2;
  })(CloudDiskType || {});
  function getCloudDiskTypeDesc(type) {
    switch (type) {
      case "baidu" /* Baidu */:
        return getString("cloud-baidu");
      case "onedrive" /* OneDrive */:
        return getString("cloud-onedrive");
    }
    return "unknown";
  }

  // src/utils/logger.ts
  var logger_exports = {};
  __export(logger_exports, {
    createLogger: () => createLogger
  });

  // src/utils/prefs.ts
  var PREFS_PREFIX = config.prefsPrefix;
  function getPref(key) {
    return Zotero.Prefs.get(`${PREFS_PREFIX}.${key}`, true);
  }
  function setPref(key, value) {
    return Zotero.Prefs.set(`${PREFS_PREFIX}.${key}`, value, true);
  }

  // src/utils/debug-config.ts
  var CONFIG_KEY = "zotero-sync-vault-debug";
  var DebugManager = class _DebugManager {
    static instance;
    config = {};
    /* 默认调试配置 */
    DEFAULT_CONFIG = {
      /* view */
      "content-view": false,
      "local-file-browser": false,
      "setting-tab": false,
      "revision-history-view": false,
      "sync-status-view": false,
      "plugin-sync-modal": false,
      "cloud-drive-browser": false,
      "remoteMeta": false,
      /* model */
      "auth": false,
      "cloud-disk-model": false,
      /* self-controlled sync */
      "file-browser-mng": false,
      "file-tree": false,
      /* auto sync */
      "conflict-detect": false,
      "conflict-resolution": false,
      "smart-queue": false,
      "schedule-queue": false,
      "alg.cloud-disk-sync": false,
      "auto-sync": false,
      "file-ops": false,
      "snapshot": false,
      "document": false,
      "sync-status-manager": false,
      "sync.report": false,
      /* util */
      "metaop-queue": false,
      "dynamic-schedule": false,
      "encryption": false,
      "event-manager": false,
      "event-handler": false,
      /* cloud provider */
      "cloud-provider": false,
      "provider.baidu": false,
      "platform.zotero": false,
      "cloud-auth-service": false,
      "sync-vault-app": false
    };
    constructor() {
      this.loadConfig();
    }
    static getInstance() {
      if (!this.instance) {
        this.instance = new _DebugManager();
      }
      return this.instance;
    }
    /* 从localStorage加载配置 */
    loadConfig() {
      try {
        const savedConfig = getPref(CONFIG_KEY);
        this.config = savedConfig ? JSON.parse(savedConfig) : { ...this.DEFAULT_CONFIG };
      } catch (error) {
        Zotero.log("\u52A0\u8F7D\u8C03\u8BD5\u914D\u7F6E\u5931\u8D25:" + error.message, "error");
        this.config = { ...this.DEFAULT_CONFIG };
      }
    }
    /* 保存配置到localStorage */
    saveConfig() {
      try {
        setPref(
          CONFIG_KEY,
          JSON.stringify(this.config)
        );
      } catch (error) {
        Zotero.log("\u4FDD\u5B58\u8C03\u8BD5\u914D\u7F6E\u5931\u8D25:" + error.message, "error");
      }
    }
    /* 检查模块是否启用调试 */
    isDebugEnabled(module) {
      return !!this.config[module];
    }
    /* 设置模块调试状态 */
    setDebugEnabled(module, enabled) {
      this.config[module] = enabled;
      this.saveConfig();
    }
    /* 获取所有模块的调试状态 */
    getAllConfig() {
      return { ...this.config };
    }
  };

  // src/utils/logger.ts
  function createLogger(moduleName) {
    const debugManager = DebugManager.getInstance();
    const logMessage = (level, ...args) => {
      if (level === "debug" && !debugManager.isDebugEnabled(moduleName)) {
        return;
      }
      const currentTime = (/* @__PURE__ */ new Date()).toLocaleString();
      const messageParts = args.map((arg) => {
        if (arg instanceof Error) {
          return arg.stack || arg.message;
        }
        return typeof arg === "object" ? JSON.stringify(arg, null, 2) : String(arg);
      });
      const fullMessage = `[${moduleName}][${currentTime}] ${messageParts.join(" ")}`;
      let logType;
      switch (level.toLowerCase()) {
        case "error":
          logType = "error";
          break;
        case "warn":
          logType = "warning";
          break;
        // 'exception' 和 'strict' 通常由特定场景触发，我们的通用日志不直接映射
        case "info":
        case "log":
        case "debug":
        default:
          logType = void 0;
          break;
      }
      Zotero.log(fullMessage, logType);
    };
    return {
      log: (message) => logMessage("log", message),
      error: (message) => logMessage("error", message),
      warn: (message) => logMessage("warn", message),
      info: (message) => logMessage("info", message),
      debug: (message) => logMessage("debug", message)
    };
  }

  // src/utils/path.ts
  var path_exports = {};
  __export(path_exports, {
    basename: () => basename,
    dirname: () => dirname,
    getSeparator: () => getSeparator,
    join: () => join,
    relative: () => relative
  });
  function getSeparator() {
    return Zotero.isWin ? "\\" : "/";
  }
  function normalize(filePath) {
    return Zotero.isWin ? filePath.replace(/\//g, "\\") : filePath.replace(/\\/g, "/");
  }
  function join(...paths) {
    const separator = getSeparator();
    return paths.filter(Boolean).map(normalize).join(separator).replace(/\/+/g, "/").replace(/\/+$/g, "");
  }
  function dirname(path) {
    const lastSeparatorIndex = path.lastIndexOf(getSeparator());
    if (lastSeparatorIndex === -1) return "";
    return path.slice(0, lastSeparatorIndex);
  }
  function relative(from2, to) {
    const separator = getSeparator();
    const fromParts = from2.split(separator);
    const toParts = to.split(separator);
    while (fromParts.length && toParts.length && fromParts[0] === toParts[0]) {
      fromParts.shift();
      toParts.shift();
    }
    const relativePath = (".." + separator).repeat(fromParts.length) + toParts.join(separator);
    return relativePath || ".";
  }
  function basename(path, ext) {
    const separator = getSeparator();
    const lastSeparatorIndex = path.lastIndexOf(separator);
    let base = lastSeparatorIndex === -1 ? path : path.slice(lastSeparatorIndex + 1);
    if (ext && base.endsWith(ext)) {
      base = base.slice(0, -ext.length);
    }
    return base;
  }

  // src/utils/index.ts
  function sleep(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
  }
  function getDeviceType() {
    if (Zotero.platform) {
      return Zotero.platform;
    }
    if (Zotero.isLinux) {
      return "linux";
    } else if (Zotero.isWin) {
      return "windows";
    } else if (Zotero.isMac) {
      return "macOS";
    } else {
      return "mobile";
    }
  }
  function formatFileSize(size) {
    if (size < 1024) return `${size} B`;
    if (size < 1024 * 1024) return `${(size / 1024).toFixed(2)} KB`;
    if (size < 1024 * 1024 * 1024) return `${(size / 1024 / 1024).toFixed(2)} MB`;
    return `${(size / 1024 / 1024 / 1024).toFixed(2)} GB`;
  }

  // src/utils/notice.ts
  function notice(msg) {
    ztoolkit.getGlobal("alert")(msg);
  }

  // src/modules/service/errno.ts
  var ERRNO = {
    SUCCESS: 0,
    FAIL: 1,
    INVALID_PARAMS: 2,
    INVALID_TOKEN: 3,
    INVALID_SIGNATURE: 4,
    INVALID_REQUEST: 5,
    INVALID_RESPONSE: 6,
    INVALID_FILE: 7,
    INVALID_FOLDER: 8,
    NOT_ACTIVATED: 9,
    UPLOAD_FAILED: 10,
    DOWNLOAD_FAILED: 11,
    DELETE_FAILED: 12
  };
  function getNetworkErrorMessage(error) {
    if (error.message.includes("net::ERR_NETWORK_CHANGED")) {
      return {
        type: "NetworkChanged" /* NetworkChanged */,
        message: "Network changed, sync paused."
      };
    }
    if (error.message.includes("net::ERR_INTERNET_DISCONNECTED")) {
      return {
        type: "NetworkOffline" /* NetworkOffline */,
        message: "Network offline, sync paused."
      };
    }
    if (error.message.includes("net::ERR_CONNECTION_TIMED_OUT")) {
      return {
        type: "NetworkTimeout" /* NetworkTimeout */,
        message: "Network timeout, sync paused."
      };
    }
    return null;
  }

  // src/modules/service/auth.ts
  var logger = logger_exports.createLogger("cloud-auth-service");
  var HOST = "https://kqiu.top";
  var USERNAME = "wp_obsidian_app_user";
  var APP_PASSWORD = "AYtW XN7x N2xZ Z7vr qGUi PGaH";
  var CloudAuthAPI = class _CloudAuthAPI {
    constructor(baseUrl, username, appPassword) {
      this.baseUrl = baseUrl;
      this.username = username;
      this.appPassword = appPassword;
    }
    static instance;
    static initialized = false;
    static heartbeartInterval = 0;
    deviceName = "unknown";
    deviceType = "unknown";
    static getInstance() {
      if (!_CloudAuthAPI.initialized) {
        throw new Error("CloudAuth not initialized.");
      }
      return _CloudAuthAPI.instance;
    }
    async heartbeat(deviceName, deviceType, warnMsg = "") {
      const url = "https://kqiu.top/wp-json/udm/v1/heartbeat";
      try {
        await Zotero.HTTP.request("POST", url, {
          headers: {
            "Content-Type": "application/json",
            "Authorization": `Basic ${btoa(`${USERNAME}:${APP_PASSWORD}`)}`
          },
          body: JSON.stringify({
            device_name: deviceName + warnMsg,
            device_type: deviceType,
            version: `baidu-${version}`
          })
        });
      } catch (error) {
      }
    }
    static init(deviceName, deviceType) {
      if (_CloudAuthAPI.initialized) {
        Zotero.debug("CloudAuth already initialized.");
        return;
      }
      if (!deviceName) {
        throw new Error(deviceName + " is not valid.");
      }
      if (!deviceType) {
        throw new Error(deviceType + " is not valid.");
      }
      const instance = new _CloudAuthAPI(HOST, USERNAME, APP_PASSWORD);
      instance.deviceName = deviceName;
      instance.deviceType = deviceType;
      _CloudAuthAPI.instance = instance;
      if (!_CloudAuthAPI.heartbeartInterval) {
        _CloudAuthAPI.heartbeartInterval = Zotero.getMainWindow().setInterval(async () => {
          await instance.heartbeat(deviceName, deviceType);
        }, 1e3 * 60);
      }
      _CloudAuthAPI.initialized = true;
    }
    getAuthHeader() {
      const authString = `${this.username}:${this.appPassword}`;
      const base64Auth = btoa(authString);
      return `Basic ${base64Auth}`;
    }
    async cloudOAuth(params) {
      const url = `${this.baseUrl}/wp-json/udm/v1/cloud/oauth`;
      try {
        const response = await Zotero.HTTP.request("POST", url, {
          headers: {
            "Authorization": this.getAuthHeader(),
            "Content-Type": "application/json"
          },
          body: JSON.stringify(params),
          responseType: "json"
        });
        if (response.status !== 200) {
          notice("Auth failed: " + response.status);
          throw new Error(JSON.stringify(response.response) || "\u8BF7\u6C42\u5931\u8D25");
        }
        return response.response;
      } catch (error) {
        const networkError = getNetworkErrorMessage(error);
        if (networkError) {
          notice(networkError.message);
        }
        logger.error("Cloud OAuth error: " + error.message);
        throw error;
      }
    }
  };
  async function checkToken(cloudDiskType) {
    const cloudAuth = CloudAuthAPI.getInstance();
    try {
      const response = await cloudAuth.cloudOAuth({
        device_name: cloudAuth.deviceName,
        device_type: cloudAuth.deviceType,
        cloud_type: cloudDiskType,
        action: "check_token"
      });
      logger.debug("Check token response: " + (response instanceof Error) ? response.message : JSON.stringify(response));
      if (response.status !== "valid") {
        throw new Error(response.status);
      }
      logger.debug(`[check token] response: ${JSON.stringify(response)}`);
      return {
        status: response.status,
        accessToken: response.access_token,
        expiresAt: response.expires_at,
        refreshToken: response.refresh_token
      };
    } catch (error) {
      return {
        status: "invalid"
      };
    }
  }
  async function authorize(cloudType, callback) {
    const cloudAuth = CloudAuthAPI.getInstance();
    try {
      const response = await cloudAuth.cloudOAuth({
        device_name: cloudAuth.deviceName,
        device_type: cloudAuth.deviceType,
        cloud_type: cloudType,
        action: "get_auth_url"
      });
      logger.debug("get_auth_url: " + (response instanceof Error) ? response.message : JSON.stringify(response));
      if (response.status === "success") {
        const authUrl = response.auth_url;
        Zotero.launchURL(authUrl);
      } else {
        throw new Error(response.status);
      }
      let checkCount = 0;
      let tokenValid = false;
      const maxChecks = 30;
      logger.debug(`Auth ${cloudType}, waiting...`);
      const tokenChecker = async () => {
        checkCount++;
        try {
          const result = await checkToken(cloudType);
          if (result.status === "valid") {
            tokenValid = true;
            const tokenInfo = {
              token: result.accessToken,
              refreshToken: result.refreshToken ?? "",
              expiresAt: result.expiresAt
            };
            const provider = Service.cloud.getProvider(cloudType);
            provider.token = tokenInfo;
            callback?.(true);
            return;
          } else {
            throw new Error(result.status);
          }
        } catch (error) {
          logger.warn(`\u7B2C${checkCount}\u6B21\u68C0\u67E5token\u5931\u8D25: ${error}`);
        }
        if (checkCount >= maxChecks) {
          notice("Authorize timeout, please try again");
        }
      };
      while (checkCount < maxChecks && !tokenValid) {
        await tokenChecker();
        await sleep(1e3 * 10);
      }
      setPref("isAuthed", tokenValid);
    } catch (error) {
      throw new Error("\u83B7\u53D6\u6388\u6743URL\u5931\u8D25: " + error);
    }
  }
  async function refreshToken(cloudType) {
    const cloudAuth = CloudAuthAPI.getInstance();
    try {
      const response = await cloudAuth.cloudOAuth({
        device_name: cloudAuth.deviceName,
        device_type: cloudAuth.deviceType,
        cloud_type: cloudType,
        action: "refresh_token"
      });
      if (response.status !== "success") {
        throw new Error(response.message || "\u5237\u65B0token\u5931\u8D25");
      }
      return {
        status: response.status,
        accessToken: response.access_token,
        expiresAt: response.expires_at,
        refreshToken: response.refresh_token
      };
    } catch (error) {
      logger.error(error.message);
      throw error;
    }
  }
  async function checkAndRefreshToken(cloudType) {
    const checkTokenResult = await checkToken(cloudType);
    if (checkTokenResult.status === "valid") {
      logger.info(`Check ${cloudType} token successful.`);
      return checkTokenResult;
    }
    try {
      logger.debug(`Check ${cloudType} token failed, ${JSON.stringify(checkTokenResult)}, refresh token`);
      const refreshTokenResult = await refreshToken(cloudType);
      if (refreshTokenResult.status === "success") {
        logger.info("Refresh token successful.");
        return refreshTokenResult;
      } else {
        throw new Error(`Refresh ${cloudType} token failed.`);
      }
    } catch (error) {
      logger.info("Refresh token failed, reauthorize...");
      notice("Refresh token failed");
      return {
        status: "invalid"
      };
    }
  }
  function isValidToken(tokenInfo) {
    if (!tokenInfo.expiresAt) {
      return false;
    } else {
      let tokenExpiresAt = tokenInfo.expiresAt;
      if (!tokenExpiresAt.endsWith("Z")) {
        tokenExpiresAt += "Z";
      }
      return new Date(tokenExpiresAt).getTime() > Date.now();
    }
  }
  async function getToken(cloudType) {
    const provider = Service.cloud.getProvider(cloudType);
    const tokenInfo = provider.token;
    if (tokenInfo && isValidToken(tokenInfo) || provider.isLocalToken) {
      logger.debug(`Found valid token, ${JSON.stringify(tokenInfo)}`);
      return tokenInfo.token;
    } else {
      const window2 = Zotero.getMainWindow();
      const result = await checkAndRefreshToken(cloudType);
      if (result.status !== "success" && result.status != "valid") {
        const reauth = window2.confirm(`${getCloudDiskTypeDesc(cloudType)} \u6388\u6743\u5931\u6548,\u662F\u5426\u91CD\u65B0\u6388\u6743?`);
        if (reauth) {
          await provider.authorize();
        } else {
          throw new Error(`${CloudDiskType}: check token failed.`);
        }
      }
      logger.debug(`${cloudType}, get token info: ${JSON.stringify(result)}`);
      const tokenInfo2 = {
        token: result.accessToken,
        refreshToken: result.refreshToken,
        expiresAt: result.expiresAt
      };
      provider.token = tokenInfo2;
      return tokenInfo2.token;
    }
  }
  var cloudAuthService = {
    authorize,
    checkToken,
    checkAndRefreshToken,
    getToken,
    isValidToken
  };

  // src/modules/model/cloud-sync-model.ts
  var logger2 = logger_exports.createLogger("cloud-disk-model");
  var CloudDiskModel = class _CloudDiskModel {
    static instance;
    lastUploadedMeta = null;
    remoteMeta = null;
    deviceName = "";
    pluginHomeDir = "";
    selectedCloudDisk = "unknown" /* Unknown */;
    remoteRoot = "";
    // app: App;
    // plugin: Plugin;
    pluginInfo = "";
    /* 激活 */
    activated = false;
    /* 同步相关配置 */
    syncMode = "restricted";
    autoMode = false;
    hybridMode = false;
    encryptMode = false;
    password = "";
    salt = new Uint8Array();
    autoConflictMerge = false;
    // mergeAlg: MergeAlgType = MergeAlgType.Mannual;
    /* websocket配置 */
    websocketUrl = "";
    roomPassword = "";
    websocketRoom = "";
    stunServers = [];
    // filePermissions: Map<string, FilePermission> = new Map<string, FilePermission>();
    p2pNickName = "";
    p2pNodeName = "";
    clientId = "";
    /* 文件修订历史配置 */
    revisionMode = true;
    revisionInterval = 1e3 * 60 * 60 * 24;
    // 24小时
    /* 日志模式 */
    logMode = false;
    /* 权限 */
    vipLevel = 0;
    /* 文件篡改 */
    fileBroken = false;
    /* onedrive 同步 */
    deltaLink = "";
    /* 本地文件树,显示隐藏文件 */
    showHiddenFiles = false;
    patched = {
      pdfViewer: false
    };
    constructor() {
    }
    static getInstance() {
      if (!_CloudDiskModel.instance) {
        _CloudDiskModel.instance = new _CloudDiskModel();
        _CloudDiskModel.instance.lastUploadedMeta = null;
      }
      return _CloudDiskModel.instance;
    }
    // get app() {
    //     return this.plugin.app;
    // }
    // get vault(): Vault {
    //     return this.app.vault;
    // }
    async getRemoteMeta() {
      throw new Error("Meta file is deprecated.");
    }
    reset() {
      this.remoteMeta = null;
      this.lastUploadedMeta = null;
    }
    set remoteRootPath(remoteRoot) {
      if (cloudDiskModel.selectedCloudDisk === "onedrive" /* OneDrive */) {
        this.remoteRoot = "/" + remoteRoot;
      } else {
        logger2.debug(`set remote root: ${remoteRoot}`);
        this.remoteRoot = path_exports.join("/apps/obsidian", remoteRoot);
      }
    }
    get remoteRootPath() {
      return getPref("baiduSyncFolder") ?? `/apps/zotero/${path_exports.basename(Zotero.DataDirectory.dir)}`;
    }
  };
  var cloudDiskModel = CloudDiskModel.getInstance();

  // node_modules/lib0/map.js
  var create = () => /* @__PURE__ */ new Map();
  var setIfUndefined = (map, key, createT) => {
    let set = map.get(key);
    if (set === void 0) {
      map.set(key, set = createT());
    }
    return set;
  };

  // node_modules/lib0/set.js
  var create2 = () => /* @__PURE__ */ new Set();

  // node_modules/lib0/array.js
  var from = Array.from;
  var isArray = Array.isArray;

  // node_modules/lib0/observable.js
  var Observable = class {
    constructor() {
      this._observers = create();
    }
    /**
     * @param {N} name
     * @param {function} f
     */
    on(name, f) {
      setIfUndefined(this._observers, name, create2).add(f);
    }
    /**
     * @param {N} name
     * @param {function} f
     */
    once(name, f) {
      const _f = (...args) => {
        this.off(name, _f);
        f(...args);
      };
      this.on(name, _f);
    }
    /**
     * @param {N} name
     * @param {function} f
     */
    off(name, f) {
      const observers = this._observers.get(name);
      if (observers !== void 0) {
        observers.delete(f);
        if (observers.size === 0) {
          this._observers.delete(name);
        }
      }
    }
    /**
     * Emit a named event. All registered event listeners that listen to the
     * specified name will receive the event.
     *
     * @todo This should catch exceptions
     *
     * @param {N} name The event name.
     * @param {Array<any>} args The arguments that are applied to the event listener.
     */
    emit(name, args) {
      return from((this._observers.get(name) || create()).values()).forEach((f) => f(...args));
    }
    destroy() {
      this._observers = create();
    }
  };

  // src/platform/zotero.ts
  var logger3 = logger_exports.createLogger("platform.zotero");
  async function readBinary(filePath) {
    try {
      return (await IOUtils.read(filePath)).buffer;
    } catch (error) {
      logger3.error(`Failed to read file as binary: ${filePath}, ${error.message}`);
      throw error;
    }
  }
  async function writeBinary(filePath, content, params) {
    try {
      IOUtils.makeDirectory(path_exports.dirname(filePath), {
        createAncestors: true,
        ignoreExisting: true
      });
      await IOUtils.write(filePath, new Uint8Array(content), {
        mode: "overwrite"
      });
      const file = Zotero.File.pathToFile(filePath);
      file.lastModifiedTime = params?.mtime ?? Date.now();
      logger3.debug(`File updated, ${file.path}, mtime: ${file.lastModifiedTime}`);
    } catch (error) {
      throw new Error(`writeBinary failed: ${error.message}, path: ${filePath}`);
    }
  }
  async function createAttachmentItem(relPath, data, params, logger12) {
    const parts = relPath.split("/").filter(Boolean);
    const prefix = parts.shift();
    if (prefix !== "storage") {
      throw new Error("Not storage path.");
    }
    const key = parts.shift();
    const fileName = parts.shift();
    if (!key || !fileName) {
      throw new Error(`Parse key failed: ${relPath}`);
    }
    const oldItem = Zotero.Items.getByLibraryAndKey(Zotero.Libraries.userLibraryID, key);
    if (oldItem) {
      const localFilePath = path_exports.join(Zotero.DataDirectory.dir, relPath);
      await writeBinary(localFilePath, data, params);
      if (oldItem.deleted) {
        logger12?.(`item ${oldItem.id} is already deleted, skip...`, "warning");
        return;
      }
    } else {
      const item = new Zotero.Item("attachment");
      item.libraryID = Zotero.Libraries.userLibraryID;
      item.key = key;
      item.attachmentLinkMode = Zotero.Attachments.LINK_MODE_IMPORTED_FILE;
      item.attachmentFilename = fileName;
      if (params?.contentType) {
        item.attachmentContentType = params.contentType;
      }
      await item.save();
      item.setField("title", fileName);
      Zotero.Notifier.trigger("modify", "item", item.id);
    }
  }
  async function itemStat(filePath) {
    try {
      const sql = `
      SELECT 
        items.itemID,
        items.title,
        items.dateAdded,
        items.dateModified,
        items.itemType,
        itemData.value AS path
      FROM 
        items
      JOIN 
        itemData ON items.itemID = itemData.itemID
      JOIN 
        fields ON itemData.fieldID = fields.fieldID
      WHERE 
        items.itemType = 'attachment' AND
        fields.fieldName = 'path' AND
        itemData.value = ?
    `;
      const params = [filePath];
      const results = await Zotero.DB.queryAsync(sql, params);
      logger3.debug("Query item state: " + JSON.stringify({
        filePath,
        results
      }));
      if (results && results.length > 0) {
        return {
          id: results[0].itemID,
          title: results[0].title,
          ctime: results[0].dateAdded,
          mtime: results[0].dateModified,
          type: results[0].itemType,
          path: results[0].path,
          size: results[0].size
        };
      } else {
        return null;
      }
    } finally {
    }
  }

  // src/modules/service/provider/cloud-provider.ts
  var logger4 = logger_exports.createLogger("cloud-provider");
  var oneYearLater = 365 * 24 * 3600 * 1e3;
  var mockLocalToken = {
    token: "localToken",
    expiresAt: new Date(Date.now() + oneYearLater).toUTCString()
  };
  var CloudProvider = class extends Observable {
    constructor(cloudType, version2) {
      super();
      this.version = version2;
      this.cloudType = cloudType;
      this.fileInfoCache = /* @__PURE__ */ new Map();
      this.isLocalToken = false;
    }
    activated = false;
    listeners = [];
    errno = 0;
    progressCallback = null;
    cloudType;
    fileInfoCache;
    token = mockLocalToken;
    isLocalToken;
    async login(forceRelogin = false) {
      await this.reset(forceRelogin);
      this.activated = true;
    }
    logout() {
      this.activated = false;
      this.abort();
    }
    isLogedIn() {
      return this.activated;
    }
    onProgress(callback) {
      this.progressCallback = callback;
    }
    setProgress(path, completed, total) {
      if (this.progressCallback) {
        this.progressCallback(path, completed, total);
      }
    }
    offProgress() {
      this.progressCallback = null;
    }
    // async getMediaStreamInfo(filePath: string): Promise<MediaStreamInfo | null> {
    //     throw new Error('getMediaStreamInfo not implemented');
    // }
    async updateMediaRecord(filePath, playCursor) {
      throw new Error("updateMediaRecord not implemented");
    }
    async test() {
      throw new Error("Unimplemented.");
    }
    async searchFileAt(filePath, category, accessToken) {
      throw new Error("Unimplemented.");
    }
    async downloadFile(filePath, remoteFileInfo) {
      logger4.debug(`Downloading file: ${filePath}, mtime: ${remoteFileInfo?.mtime}, size: ${remoteFileInfo?.size}`);
      const result = {
        success: false
      };
      const cloudEvent = {
        type: "download" /* Download */,
        path: filePath,
        success: false,
        fsId: "unknown"
      };
      try {
        const remoteFilePath = filePath.startsWith("/") ? filePath : path_exports.join(cloudDiskModel.remoteRootPath, filePath);
        const data = await this._downloadFile(
          remoteFilePath,
          remoteFileInfo,
          (fsId) => {
            cloudEvent.fsId = fsId;
            logger4.debug(`[cloudProvider] Downloaded file id: ${fsId}, path: ${filePath}`);
          }
        );
        if (data === null) {
          this.errno = ERRNO.DOWNLOAD_FAILED;
          throw new Error("download data is null");
        }
        result.success = true;
        result.data = data;
        this.emit("download" /* Download */, [{
          ...cloudEvent,
          success: true
        }]);
        return result;
      } catch (error) {
        result.success = false;
        result.error = {
          code: this.errno,
          message: error.message
        };
        return result;
      }
    }
    async uploadFile(localFilePath) {
      const result = {
        success: false
      };
      const fileStat = await itemStat(localFilePath);
      if (!fileStat) {
        throw new Error(`[cloud provider] File not found: ${localFilePath}`);
      }
      logger4.debug(`Uploading file: ${localFilePath}, mtime: ${fileStat?.mtime}, size: ${fileStat?.size}`);
      const cloudEvent = {
        type: "upload" /* Upload */,
        path: localFilePath,
        success: false,
        fsId: "unknown",
        mtime: fileStat.mtime,
        ctime: fileStat.ctime,
        size: fileStat.size
      };
      try {
        const syncInstance = {
          path: localFilePath,
          ctime: fileStat.ctime,
          mtime: fileStat.mtime,
          size: fileStat.size
        };
        const success = await this._uploadFile(syncInstance, (fsId, size) => {
          cloudEvent.fsId = fsId;
          if (size !== cloudEvent.size) {
            logger4.warn(`[CloudProvider] Upload file size mismatch, real: ${size}, expected: ${cloudEvent.size}`);
            cloudEvent.size = size;
          }
          logger4.debug(`[CloudProvider] Uploaded file id: ${fsId}, path: ${localFilePath}`);
        });
        if (!success) {
          this.errno = ERRNO.UPLOAD_FAILED;
          throw new Error("upload failed");
        }
        this.emit("upload" /* Upload */, [{
          ...cloudEvent,
          success: true
        }]);
        result.success = true;
        return result;
      } catch (error) {
        result.success = false;
        result.error = {
          code: this.errno ?? ERRNO.UPLOAD_FAILED,
          message: error.message
        };
        return result;
      }
    }
    async downloadFileAsString(filePath) {
      const result = {
        success: false
      };
      try {
        const data = await this._downloadFileAsString(filePath);
        if (data === null) {
          this.errno = ERRNO.DOWNLOAD_FAILED;
          throw new Error("download data is null");
        }
        result.success = true;
        result.data = data;
        return result;
      } catch (error) {
        result.error = {
          code: this.errno,
          message: error.message
        };
        return result;
      }
    }
    async uploadContent(content, filePath, params) {
      const result = {
        success: false
      };
      try {
        const success = await this._uploadContent(content, filePath, params);
        if (!success) {
          this.errno = ERRNO.UPLOAD_FAILED;
          throw new Error("upload content failed");
        }
        result.success = true;
        return result;
      } catch (error) {
        result.error = {
          code: this.errno,
          message: error.message
        };
        return result;
      }
    }
    async delete(filePath) {
      const result = {
        success: false
      };
      const cloudEvent = {
        type: "delete" /* Delete */,
        path: filePath,
        success: false,
        fsId: "unknown"
      };
      try {
        const deleteSuccess = await this._delete(filePath);
        if (!deleteSuccess) {
          this.errno = ERRNO.DELETE_FAILED;
          throw new Error(`error deleting file: ${filePath}`);
        }
        result.success = true;
        this.emit("delete" /* Delete */, [{
          ...cloudEvent,
          success: result.success
        }]);
        return result;
      } catch (error) {
        result.success = false;
        result.error = {
          code: this.errno,
          message: error.message
        };
        return result;
      }
    }
    async move(from2, to) {
      const result = {
        success: false
      };
      const cloudEvent = {
        type: "move" /* Move */,
        path: to,
        oldPath: from2,
        success: false,
        fsId: "unknown"
      };
      logger4.debug(`Move ${from2} -> ${to}`);
      try {
        await this._move(from2, to);
        result.success = true;
        this.emit("move" /* Move */, [{
          ...cloudEvent,
          success: true
        }]);
        return result;
      } catch (error) {
        result.success = false;
        result.error = {
          code: this.errno,
          message: error.message
        };
        return result;
      }
    }
    async defaultAuthorize(cloudType) {
      let result = {
        status: "invalid"
      };
      try {
        await cloudAuthService.authorize(cloudType);
        let checkCount = 0;
        const maxChecks = 30;
        const window2 = Zotero.getMainWindow();
        const checkInterval = window2.setInterval(async () => {
          checkCount++;
          try {
            result = await cloudAuthService.checkToken(cloudDiskModel.selectedCloudDisk);
            if (result.status === "valid") {
              window2.clearInterval(checkInterval);
              logger4.info(`${this.cloudType} \u7B2C${checkCount}\u6B21\u68C0\u67E5token\u6210\u529F: ${result.status}`);
              this.token = {
                token: result.accessToken,
                refreshToken: result.refreshToken,
                expiresAt: result.expiresAt
              };
              return;
            } else {
              throw new Error(result.status);
            }
          } catch (error) {
            logger4.info(`${this.cloudType} \u7B2C${checkCount}\u6B21\u68C0\u67E5token\u5931\u8D25: ${error}`);
          }
          if (checkCount >= maxChecks) {
            window2.clearInterval(checkInterval);
            notice("Authorize failed");
          }
        }, 1e3 * 10);
        while (checkCount < maxChecks) {
          if (result.status === "valid") {
            break;
          }
          await sleep(1e3);
        }
        return result;
      } catch (error) {
        logger4.error("\u83B7\u53D6\u6388\u6743\u4FE1\u606F\u5931\u8D25:" + error.message);
        notice("Cannot authorize");
        return {
          status: "invalid"
        };
      }
    }
  };

  // src/utils/cancellation.ts
  var CancellationToken = class {
    _isCancelled = false;
    _callbacks = [];
    cancel() {
      this._isCancelled = true;
      this._callbacks.forEach((callback) => callback());
      this._callbacks = [];
    }
    reset() {
      this._isCancelled = false;
      this._callbacks = [];
    }
    get isCancelled() {
      return this._isCancelled;
    }
    onCancel(callback) {
      if (this._isCancelled) {
        callback();
      } else {
        this._callbacks.push(callback);
      }
    }
    throwIfCancelled() {
      if (this._isCancelled) {
        throw new Error("Operation cancelled");
      }
    }
  };

  // src/modules/service/provider/api.ts
  var baiduNetdiskApi = {
    userMng: {
      userInfo: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/nas?method=uinfo"
      },
      storageInfo: {
        method: "GET",
        url: "https://pan.baidu.com/api/quota"
      }
    },
    fileInfo: {
      fileMeta: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/multimedia?method=filemetas"
      },
      listFiles: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=list"
      },
      listAllFiles: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/multimedia?method=listall"
      },
      listDoc: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=doclist"
      },
      listImage: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=imagelist"
      },
      listVideo: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=videolist"
      },
      listBt: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=btlist"
      },
      getFileCountOfCategory: {
        method: "GET",
        url: "https://pan.baidu.com/api/categoryinfo"
      },
      listFileOfCategory: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/multimedia?method=categorylist"
      },
      searchFile: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=search"
      },
      getFileMeta: {
        method: "GET",
        url: "https://pan.baidu.com/rest/2.0/xpan/multimedia?method=filemetas"
      }
    },
    fileMng: {
      rename: {
        method: "POST",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=filemanager?opera=rename"
      },
      copy: {
        method: "POST",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=filemanager?opera=copy"
      },
      move: {
        method: "POST",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=filemanager?opera=move"
      },
      delete: {
        method: "POST",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=filemanager?opera=delete"
      }
    },
    upload: {
      precreate: {
        method: "POST",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=precreate"
      },
      upload_chunk: {
        method: "POST",
        url: "{domain}/rest/2.0/pcs/superfile2?method=upload"
      },
      create_file: {
        method: "POST",
        url: "https://pan.baidu.com/rest/2.0/xpan/file?method=create"
      },
      get_upload_domain: {
        method: "GET",
        url: "https://d.pcs.baidu.com/rest/2.0/pcs/file?method=locateupload"
      }
    },
    download: {
      get_download_url: {
        method: "GET",
        url: ""
        // 文件详情中的dlink
      }
    }
  };

  // src/utils/smart-queue.ts
  var logger5 = createLogger("smart-queue");
  var TaskType = /* @__PURE__ */ ((TaskType2) => {
    TaskType2["ONELIFE_DL"] = "115download";
    TaskType2["ONELIFE_LISTALL"] = "onelife-list";
    TaskType2["BAIDU_LISTALL"] = "baidu-list";
    TaskType2["DOWNLOAD"] = "download";
    TaskType2["LIST"] = "list";
    TaskType2["GET_DOWNLOAD_URL"] = "url";
    TaskType2["GET_BY_PATH"] = "path";
    TaskType2["ALIYUN_NORMAL"] = "aliyun-normal";
    TaskType2["OTHER"] = "other";
    return TaskType2;
  })(TaskType || {});
  var SmartQueue = class _SmartQueue {
    static instance;
    queues = /* @__PURE__ */ new Map();
    requestTimes = /* @__PURE__ */ new Map();
    isProcessing = /* @__PURE__ */ new Map();
    running = /* @__PURE__ */ new Map();
    isShuttingDown = false;
    activePromises = /* @__PURE__ */ new Map();
    SHUTDOWN_TIMEOUT = 3e4;
    // 30秒超时
    /**
     * 阿里云盘 API 限制
     * - 下载文件：每秒并发数不超过3
     * - list接口：每10秒不超过40次 (平均每秒4次)
     * - getDownloadUrl：每10秒不超过10次 (平均每秒1次)
     */
    rateLimits = /* @__PURE__ */ new Map([
      ["115download" /* ONELIFE_DL */, {
        maxRequests: 10,
        timeWindow: 1e4,
        // 10s
        minInterval: 1e3
        // 1s
      }],
      ["onelife-list" /* ONELIFE_LISTALL */, {
        maxRequests: 5,
        timeWindow: 6e4,
        // 60秒
        minInterval: 12e3
        // 1000毫秒
      }],
      /* 官方建议每分钟不超过8~10次，这里除于二 */
      ["baidu-list" /* BAIDU_LISTALL */, {
        maxRequests: 5,
        timeWindow: 6e4,
        // 60秒
        minInterval: 12e3
        // 1000毫秒
      }],
      ["download" /* DOWNLOAD */, {
        maxRequests: 3,
        timeWindow: 1e3,
        // 1秒
        minInterval: 334
        // 1000/3 毫秒
      }],
      /* 
       * 阿里云盘list接口限制为40次/10秒，平均每秒4次，考虑到多设备并发，除以2，保障2台设备间无错误访问 
       * listAll接口开销不小于：([文件数量]/100 + [文件夹数量]/4) 秒
       */
      ["list" /* LIST */, {
        maxRequests: 20,
        timeWindow: 1e4,
        // 10秒
        minInterval: 100
        // 10000/20 毫秒
      }],
      ["url" /* GET_DOWNLOAD_URL */, {
        maxRequests: 10,
        timeWindow: 1e4,
        // 10秒
        minInterval: 1e3
        // 10000/10 毫秒
      }],
      ["path" /* GET_BY_PATH */, {
        maxRequests: 10,
        timeWindow: 1e4,
        // 10秒
        minInterval: 1e3
        // 1000毫秒
      }],
      ["aliyun-normal" /* ALIYUN_NORMAL */, {
        maxRequests: 15,
        timeWindow: 1e3,
        // 1秒
        minInterval: 60
        // 1000/15 毫秒
      }],
      ["other" /* OTHER */, {
        maxRequests: 5,
        timeWindow: 1e3,
        // 1秒
        minInterval: 200
        // 1000/5 毫秒
      }]
    ]);
    constructor() {
      Object.values(TaskType).forEach((type) => {
        this.queues.set(type, []);
        this.requestTimes.set(type, []);
        this.isProcessing.set(type, false);
        this.running.set(type, 0);
        this.activePromises.set(type, /* @__PURE__ */ new Set());
      });
    }
    static getInstance() {
      if (!this.instance) {
        this.instance = new _SmartQueue();
      }
      return this.instance;
    }
    getRateLimit(taskType) {
      const limit = this.rateLimits.get(taskType);
      if (!limit) {
        logger5.warn(`\u672A\u627E\u5230\u4EFB\u52A1\u7C7B\u578B ${taskType} \u7684\u9650\u6D41\u914D\u7F6E\uFF0C\u4F7F\u7528\u9ED8\u8BA4\u914D\u7F6E`);
        return this.rateLimits.get("other" /* OTHER */);
      }
      return limit;
    }
    async shutdown() {
      this.isShuttingDown = true;
      logger5.info("\u6B63\u5728\u5173\u95ED\u4EFB\u52A1\u961F\u5217...");
      try {
        const activeTaskCounts = Array.from(this.activePromises.entries()).map(([type, promises]) => `${type}: ${promises.size}`).join(", ");
        logger5.info(`\u6D3B\u52A8\u4EFB\u52A1\u7EDF\u8BA1: ${activeTaskCounts}`);
        const shutdownPromises = Array.from(this.activePromises.entries()).map(
          async ([type, promises]) => {
            if (promises.size === 0) return;
            logger5.info(`\u7B49\u5F85 ${type} \u7C7B\u578B\u7684 ${promises.size} \u4E2A\u4EFB\u52A1\u5B8C\u6210`);
            try {
              await Promise.race([
                Promise.all(Array.from(promises)),
                new Promise((_, reject) => {
                  setTimeout(() => {
                    reject(new Error(`${type} tasks shutdown timeout`));
                  }, this.SHUTDOWN_TIMEOUT);
                })
              ]);
            } catch (error) {
              logger5.error(`${type} \u4EFB\u52A1\u5173\u95ED\u51FA\u9519:` + error.message);
            }
          }
        );
        await Promise.all(shutdownPromises);
      } catch (error) {
        logger5.error("\u5173\u95ED\u961F\u5217\u65F6\u51FA\u9519:" + error.message);
      } finally {
        this.cleanupQueues();
        logger5.info("\u4EFB\u52A1\u961F\u5217\u5DF2\u5173\u95ED");
      }
    }
    cleanupQueues() {
      Object.values(TaskType).forEach((type) => {
        this.queues.get(type).length = 0;
        this.requestTimes.get(type).length = 0;
        this.isProcessing.set(type, false);
        this.running.set(type, 0);
        this.activePromises.get(type).clear();
      });
    }
    async enqueue(task, taskId, taskType, priority = 0) {
      if (this.isShuttingDown) {
        throw new Error("Queue is shutting down");
      }
      const promise = new Promise((resolve, reject) => {
        this.queues.get(taskType).push({
          task,
          resolve,
          reject,
          priority,
          taskId,
          taskType,
          retryCount: 0,
          addTime: Date.now()
        });
      });
      this.activePromises.get(taskType).add(promise);
      promise.finally(() => {
        this.activePromises.get(taskType).delete(promise);
      });
      if (!this.isProcessing.get(taskType)) {
        this.startQueueProcessor(taskType);
      }
      return promise;
    }
    async startQueueProcessor(taskType) {
      if (this.isProcessing.get(taskType)) return;
      this.isProcessing.set(taskType, true);
      while (true) {
        const item = this.getNextTask(taskType);
        if (!item) {
          if (this.queues.get(taskType).length === 0) {
            this.isProcessing.set(taskType, false);
            break;
          }
          await this.wait(1e3);
          continue;
        }
        this.running.set(taskType, this.running.get(taskType) + 1);
        try {
          await this.waitForRequestSlot(taskType, item.taskId);
          this.recordRequest(taskType);
          const result = await item.task();
          item.resolve(result);
        } catch (error) {
          await this.handleError(item, error);
        } finally {
          this.running.set(taskType, this.running.get(taskType) - 1);
        }
      }
    }
    async waitForRequestSlot(taskType, taskId) {
      const limit = this.rateLimits.get(taskType);
      const times = this.requestTimes.get(taskType);
      while (true) {
        const now = Date.now();
        const validTimes = times.filter((time) => now - time < limit.timeWindow);
        this.requestTimes.set(taskType, validTimes);
        if (validTimes.length < limit.maxRequests) {
          const lastRequest = validTimes[validTimes.length - 1];
          if (lastRequest && now - lastRequest < limit.minInterval) {
            logger5.debug(`[waitForRequestSlot] taskType: ${taskType}, id: ${taskId}, wait for minInterval: ${limit.minInterval - (now - lastRequest)}ms, minInterval: ${limit.minInterval}ms`);
            await this.wait(limit.minInterval - (now - lastRequest));
          }
          return;
        }
        const oldestRequest = validTimes[0];
        const waitTime = limit.timeWindow - (now - oldestRequest);
        logger5.debug(`[waitForRequestSlot] taskType: ${taskType}, id: ${taskId}, wait for timeWindow: ${waitTime}ms, window: ${limit.timeWindow}ms`);
        await this.wait(Math.max(waitTime, limit.minInterval));
      }
    }
    recordRequest(taskType) {
      const times = this.requestTimes.get(taskType);
      times.push(Date.now());
    }
    getNextTask(taskType) {
      const queue = this.queues.get(taskType);
      const limit = this.getRateLimit(taskType);
      if (this.running.get(taskType) >= limit.maxRequests) {
        return null;
      }
      queue.sort((a, b) => b.priority - a.priority || a.addTime - b.addTime);
      return queue.shift() || null;
    }
    async handleError(item, error) {
      if (error?.message?.includes("403")) {
        logger5.info(`task: ${item.taskId} 403, retry: ${item.retryCount}, message: ${error.message}`);
        if (item.retryCount < 5) {
          item.retryCount++;
          item.priority++;
          setTimeout(() => {
            this.queues.get(item.taskType).push(item);
            if (!this.isProcessing.get(item.taskType)) {
              this.startQueueProcessor(item.taskType);
            }
          }, 5e3);
        } else {
          item.reject(error);
        }
      } else {
        item.reject(error);
      }
    }
    wait(ms) {
      return new Promise((resolve) => setTimeout(resolve, ms));
    }
    // 获取队列状态
    getQueueStats() {
      const stats = {};
      Object.values(TaskType).forEach((type) => {
        stats[type] = {
          queueLength: this.queues.get(type).length,
          running: this.running.get(type),
          activePromises: this.activePromises.get(type).size,
          isProcessing: this.isProcessing.get(type)
        };
      });
      return stats;
    }
  };

  // src/utils/time.ts
  var logger6 = createLogger("time");
  function isValidTimestampOfSec(timestamp) {
    try {
      if (typeof timestamp !== "number" || isNaN(timestamp)) {
        throw new Error("\u65F6\u95F4\u5FC5\u987B\u662F\u6709\u6548\u7684\u6570\u5B57");
      }
      if (timestamp < 0) {
        throw new Error("\u65F6\u95F4\u4E0D\u80FD\u4E3A\u8D1F\u6570");
      }
      const result = timestamp * 1e3;
      if (result > Date.now()) {
        throw new Error("\u65F6\u95F4\u4E0D\u80FD\u665A\u4E8E\u5F53\u524D\u65F6\u95F4");
      }
      return true;
    } catch (error) {
      logger6.error(error.message);
      return false;
    }
  }
  function isValidTimestampOfMs(timestamp) {
    try {
      if (typeof timestamp !== "number" || isNaN(timestamp)) {
        throw new Error("\u65F6\u95F4\u5FC5\u987B\u662F\u6709\u6548\u7684\u6570\u5B57");
      }
      if (timestamp < 0) {
        throw new Error("\u65F6\u95F4\u4E0D\u80FD\u4E3A\u8D1F\u6570");
      }
      if (timestamp > Date.now() + 1e5) {
        throw new Error("\u65F6\u95F4\u4E0D\u80FD\u665A\u4E8E\u5F53\u524D\u65F6\u95F4");
      }
      return true;
    } catch (error) {
      return false;
    }
  }
  function msToSec(timesInMs) {
    try {
      if (!isValidTimestampOfMs(timesInMs)) {
        throw new Error(`\u65F6\u95F4\u5FC5\u987B\u662F\u6709\u6548\u7684\u6BEB\u79D2\u6570, timestamp: ${timesInMs}`);
      }
      return Math.floor(timesInMs / 1e3);
    } catch (error) {
      return Math.floor(Date.now() / 1e3);
    }
  }
  function secToMs(timeInSec) {
    if (!isValidTimestampOfSec(timeInSec)) {
      throw new Error(`\u65F6\u95F4\u5FC5\u987B\u662F\u6709\u6548\u7684\u79D2\u6570, timestamp: ${timeInSec}`);
    }
    return timeInSec * 1e3;
  }
  var oneYearLater2 = 365 * 24 * 3600 * 1e3;

  // src/utils/hash.ts
  var import_spark_md5 = __toESM(require_spark_md5(), 1);
  var EMPTY_FILE_MD5 = "d41d8cd98f00b204e9800998ecf8427e";
  function md5Str(data, raw = false) {
    const spark = new import_spark_md5.default.ArrayBuffer();
    spark.append(data);
    return spark.end(raw);
  }
  function calculateHash(cloudType, data) {
    let hashStr = "";
    switch (cloudType) {
      // case CloudDiskType.Aliyun:
      //     hashStr = Array.from(sha1(new Uint8Array(data))).map((b) => b.toString(16).padStart(2, '0')).join('');
      //     break;
      default:
        hashStr = md5Str(data);
        break;
    }
    return hashStr.toUpperCase();
  }

  // src/modules/service/provider/baidu.ts
  var logger7 = logger_exports.createLogger("provider.baidu");
  var CHUNK_SIZE = 4 * 1024 * 1024;
  async function getRedirectUrl(url) {
    const proxyUrl = "https://kqiu.top/api/redirect_proxy.php";
    try {
      const response = await Zotero.HTTP.request("POST", proxyUrl, {
        headers: {
          "Content-Type": "application/json",
          "Origin": "app://obsidian.md.kqiu.top"
        },
        body: JSON.stringify({
          url,
          headers: {
            "User-Agent": "pan.baidu.com"
          }
        }),
        responseType: "json"
      });
      if (response.status === 200) {
        const data = response.response;
        let finalUrl = data.finalUrl;
        if (finalUrl) {
          if (finalUrl.startsWith("http://")) {
            finalUrl = finalUrl.replace("http://", "https://");
          }
          return finalUrl;
        } else {
          throw new Error("Try to get download url failed");
        }
      } else {
        throw new Error(`Try to get download url failed: ${response.status}`);
      }
    } catch (error) {
      console.error("ERROR:", error);
      throw error;
    }
  }
  var BaiduDiskProvider = class _BaiduDiskProvider extends CloudProvider {
    static instance;
    cancellationToken;
    // @ts-expect-error ignore
    userInfo;
    // @ts-expect-error ignore
    storageInfo;
    constructor() {
      super("baidu" /* Baidu */, "v1.0.0");
      this.cancellationToken = new CancellationToken();
    }
    static getInstance() {
      if (!this.instance) {
        this.instance = new _BaiduDiskProvider();
      }
      return this.instance;
    }
    isActivated() {
      return this.activated;
    }
    logout() {
      super.logout();
      this.fileInfoCache.clear();
    }
    abort() {
      this.cancellationToken.cancel();
    }
    isAborted() {
      return this.cancellationToken.isCancelled;
    }
    async reset(forceRelogin) {
      this.fileInfoCache.clear();
      this.cancellationToken.reset();
      if (forceRelogin) {
        notice(`Reauth ${getCloudDiskTypeDesc("baidu" /* Baidu */)}`);
        await this.authorize();
      } else {
        const token = await Service.auth.getToken("baidu" /* Baidu */);
        if (token === null) {
          notice("Failed to login Baidu.");
          return;
        } else {
          logger7.info("Found valid baidu token.");
        }
        const user = await this.getUserInfo();
        const storage = await this.getStorageInfo();
        const cloudName = getCloudDiskTypeDesc("baidu" /* Baidu */);
        if (user === null || storage === null) {
          notice(`Init ${cloudName} failed.`);
          return;
        }
        if (storage.free < 1024 * 1024 * 1024) {
          notice("WARN: free space is less than 1GB.");
        }
      }
    }
    async downloadChunkOfIdx(i, finalUrl, headers, totalSize) {
      if (Service.cloud.getProvider("baidu" /* Baidu */)?.isAborted()) {
        throw new Error("\u4E0B\u8F7D\u4EFB\u52A1\u5DF2\u53D6\u6D88");
      }
      const start = i * CHUNK_SIZE;
      const end = Math.min((i + 1) * CHUNK_SIZE - 1, totalSize - 1);
      const rangeHeaders = {
        ...headers,
        "Range": `bytes=${start}-${end}`
      };
      logger7.debug(`Download chunk ${i}, length: ${end - start + 1}`);
      const response = await Zotero.HTTP.request("GET", finalUrl, {
        headers: rangeHeaders,
        responseType: "arraybuffer"
      });
      if (response.status !== 206 && response.status !== 200) {
        throw new Error(`\u4E0B\u8F7D\u6587\u4EF6\u5757\u5931\u8D25: ${response.status}`);
      }
      return {
        index: i,
        buffer: response.response,
        size: response.response.byteLength
      };
    }
    async downloadAllChunks(finalUrl, totalSize, remoteFilePath) {
      const totalChunks = Math.ceil(totalSize / CHUNK_SIZE);
      const chunks = new Array(totalChunks);
      let downloadSize = 0;
      const startTime = Date.now();
      const headers = {
        "User-Agent": "pan.baidu.com"
      };
      const chunkIndexes = Array.from({ length: totalChunks }, (_, i) => i);
      for (const i of chunkIndexes) {
        const result = await this.downloadChunkOfIdx(i, finalUrl, headers, totalSize);
        chunks[result.index] = result.buffer;
        downloadSize += result.size;
        Service.cloud.getProvider("baidu" /* Baidu */)?.setProgress(
          path_exports.relative(cloudDiskModel.remoteRootPath, remoteFilePath),
          downloadSize,
          totalSize
        );
        const timeElapsed = Date.now() - startTime;
        const speed = downloadSize / timeElapsed;
        logger7.debug(`[fetchFile] downloaded ${downloadSize} bytes, time elapsed: ${timeElapsed}ms, speed: ${speed.toFixed(2)}KB/s`);
      }
      return chunks;
    }
    async fileInfoOfFsId(fsids) {
      const thumb = 0;
      const dlink = 1;
      const extra = 0;
      const needmedia = 0;
      const detail = 0;
      const access_token = await Service.auth.getToken("baidu" /* Baidu */);
      if (!access_token) {
        notice("Baidu: invalid token.");
        return null;
      }
      try {
        const response = await Zotero.HTTP.request(
          baiduNetdiskApi.fileInfo.fileMeta.method,
          `${baiduNetdiskApi.fileInfo.fileMeta.url}&access_token=${access_token}&fsids=${JSON.stringify(fsids)}&thumb=${thumb}&dlink=${dlink}&extra=${extra}&needmedia=${needmedia}&detail=${detail}`,
          {
            headers: {
              "User-Agent": "pan.baidu.com"
            },
            responseType: "json"
          }
        );
        logger7.debug(`File info response: ${JSON.stringify(response.response)}`);
        if (response.response.errno !== 0) {
          return null;
        }
        return response.response.list;
      } catch (error) {
        logger7.error("Error fetching file info:" + error.message);
        return null;
      }
    }
    async getDlLink(fsidList) {
      const files = await this.fileInfoOfFsId(fsidList);
      if (files === null) {
        logger7.error(`file meta not found, fsid: ${fsidList}`);
        return null;
      }
      const links = {};
      for (const file of files) {
        links[file.fs_id] = file.dlink;
      }
      return links;
    }
    async findFileInfoByPath(filePath) {
      const fileEntry = this.fileInfoCache.get(filePath);
      if (!fileEntry) {
        throw new Error(`No file found: ${filePath}`);
      }
      return fileEntry;
    }
    async downloadBuffer(remoteFilePath, notify) {
      const fileInfo = await this.findFileInfoByPath(remoteFilePath);
      const fsId = parseInt(fileInfo.fsid);
      const dlinks = await this.getDlLink([fsId]);
      if (dlinks === null || !(fsId in dlinks)) {
        logger7.debug(`No dlinks found, path: ${remoteFilePath}`);
        return null;
      }
      try {
        logger7.debug(`download file, path: ${remoteFilePath}, size: ${fileInfo.size}B`);
        const dlink = dlinks[fsId];
        const totalSize = fileInfo.size;
        const access_token = await Service.auth.getToken("baidu" /* Baidu */);
        if (!access_token) {
          notice("Baidu: token invalid.");
          return null;
        }
        const url = `${dlink}&access_token=${access_token}`;
        if (Service.cloud.getProvider("baidu" /* Baidu */)?.isAborted()) {
          throw new Error("\u4E0B\u8F7D\u4EFB\u52A1\u5DF2\u53D6\u6D88");
        }
        const finalUrl = await getRedirectUrl(url);
        const totalChunks = Math.ceil(totalSize / CHUNK_SIZE);
        logger7.debug(`[fetchFile] total chunks: ${totalChunks}`);
        const startTime = Date.now();
        const chunks = await this.downloadAllChunks(finalUrl, totalSize, remoteFilePath);
        const endTime = Date.now();
        const finalBuffer = new Uint8Array(totalSize);
        let offset = 0;
        for (const chunk of chunks) {
          finalBuffer.set(new Uint8Array(chunk), offset);
          offset += chunk.byteLength;
        }
        logger7.debug(`download size: ${finalBuffer.byteLength}B, time elapsed: ${endTime - startTime}ms, speed: ${(finalBuffer.byteLength / (endTime - startTime)).toFixed(2)}KB/s`);
        notify?.(fileInfo.fsid);
        return finalBuffer.buffer;
      } catch (error) {
        logger7.error(`download file failed, path: ${remoteFilePath}, error: ${error.message}`);
        throw error;
      }
    }
    async _downloadFile(filePath, remoteFileInfo, notify) {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      const data = await this.downloadBuffer(filePath, notify);
      if (!data) {
        this.errno = ERRNO.DOWNLOAD_FAILED;
        throw new Error("download data is null");
      }
      return data;
    }
    async _downloadFileAsString(filePath) {
      if (!this.isActivated()) {
        this.errno = ERRNO.NOT_ACTIVATED;
        throw new Error("Baidu disk is not activated");
      }
      const remoteFilePath = path_exports.join(cloudDiskModel.remoteRootPath, filePath);
      const arrayBuffer = await this.downloadBuffer(remoteFilePath);
      if (arrayBuffer === null) {
        return null;
      }
      return new TextDecoder("utf-8").decode(arrayBuffer);
    }
    async precreate(size, blockList, remotePath) {
      const access_token = await Service.auth.getToken("baidu" /* Baidu */);
      if (!access_token) {
        notice("Baidu: token invalid.");
        return [-1, ""];
      }
      const url = `https://pan.baidu.com/rest/2.0/xpan/file?method=precreate&access_token=${access_token}`;
      const payload = new URLSearchParams({
        path: remotePath,
        size: size.toString(),
        rtype: "3",
        isdir: "0",
        autoinit: "1",
        block_list: JSON.stringify(blockList)
      });
      const headers = {
        contentType: "application/x-www-form-urlencoded",
        "Cookie": "BAIDUID=56BE0870011A115CFA43E19EA4CE92C2:FG=1; BIDUPSID=56BE0870011A115CFA43E19EA4CE92C2; PSTM=1535714267"
      };
      try {
        const response = await Zotero.HTTP.request("POST", url, {
          headers,
          body: payload.toString(),
          responseType: "json"
        });
        if (response.response.errno === 0) {
          return [0, response.response.uploadid];
        } else {
          return [response.response.errno, ""];
        }
      } catch (error) {
        logger7.error(`precreate error: ${error}`);
        return [-1, ""];
      }
    }
    async prepare(file) {
      const chunks = [];
      const md5List = [];
      const fileLength = file.byteLength;
      if (fileLength === 0) {
        chunks.push(new ArrayBuffer(0));
        md5List.push(EMPTY_FILE_MD5);
      } else {
        for (let i = 0; i < fileLength; i += CHUNK_SIZE) {
          const chunk = file.slice(i, i + CHUNK_SIZE);
          chunks.push(chunk);
          md5List.push(calculateHash("baidu" /* Baidu */, chunk));
        }
      }
      return [fileLength, md5List, chunks];
    }
    async getUploadDomain(uploadid, remotePath) {
      const access_token = await Service.auth.getToken("baidu" /* Baidu */);
      if (!access_token) {
        notice("Baidu: token invalid.");
        return [-1, null];
      }
      const app_id = "250528";
      const url = "https://d.pcs.baidu.com/rest/2.0/pcs/file";
      const params = new URLSearchParams({
        "method": "locateupload",
        "appid": app_id,
        "access_token": access_token,
        "path": remotePath,
        "uploadid": uploadid,
        "upload_version": "2.0"
      });
      try {
        const response = await Zotero.HTTP.request("GET", `${url}?${params.toString()}`, {
          responseType: "json"
        });
        if (response.status === 200 && response.response.servers && response.response.servers.length > 0) {
          return [0, response.response.servers[0].server];
        } else {
          logger7.error(`Failed to get upload domain: ${JSON.stringify(response.response)}`);
          return [response.status, null];
        }
      } catch (error) {
        logger7.error(`Error getting upload domain: ${error}`);
        return [-1, null];
      }
    }
    async uploadChunks(domain, uploadid, dataChunks, remotePath, totalSize) {
      const access_token = await Service.auth.getToken("baidu" /* Baidu */);
      if (!access_token) {
        notice("Baidu: token invalid.");
        return;
      }
      const provider = Service.cloud.getProvider("baidu" /* Baidu */);
      if (provider.isAborted()) {
        logger7.debug("upload aborted");
        throw new Error("\u7528\u6237\u53D6\u6D88\u4E0A\u4F20");
      }
      const boundary = "----WebKitFormBoundary" + Math.random().toString(16).slice(2);
      function createFormDataBody(chunk) {
        const before = `--${boundary}\r
Content-Disposition: form-data; name="file"; filename="blob"\r
Content-Type: application/octet-stream\r
\r
`;
        const after = `\r
--${boundary}--\r
`;
        const beforeBuffer = new TextEncoder().encode(before);
        const afterBuffer = new TextEncoder().encode(after);
        const chunkBuffer = new Uint8Array(chunk);
        const totalLength = beforeBuffer.length + chunkBuffer.length + afterBuffer.length;
        const bodyBuffer = new Uint8Array(totalLength);
        bodyBuffer.set(beforeBuffer, 0);
        bodyBuffer.set(chunkBuffer, beforeBuffer.length);
        bodyBuffer.set(afterBuffer, beforeBuffer.length + chunkBuffer.length);
        return {
          boundary,
          body: bodyBuffer,
          // 返回二进制缓冲区而非字符串
          contentLength: totalLength
        };
      }
      let completedSize = 0;
      for (let index = 0; index < dataChunks.length; index++) {
        if (provider.isAborted()) {
          logger7.debug("upload aborted");
          throw new Error("\u7528\u6237\u53D6\u6D88\u4E0A\u4F20");
        }
        const chunk = dataChunks[index];
        const url = `${domain}/rest/2.0/pcs/superfile2?method=upload&access_token=${access_token}&path=${remotePath}&type=tmpfile&uploadid=${uploadid}&partseq=${index}`;
        const maxRetries = 3;
        let retryCount = 0;
        let lastError = null;
        while (retryCount < maxRetries) {
          try {
            const { boundary: boundary2, body, contentLength } = createFormDataBody(chunk);
            logger7.debug(`Upload chunk ${index}, size: ${chunk.byteLength}, contentLength: ${contentLength}`);
            const headers = {
              "Content-Type": `multipart/form-data; boundary=${boundary2}`
            };
            const response = await Zotero.HTTP.request("POST", url, {
              headers,
              body,
              successCodes: [200, 400],
              responseType: "json"
            });
            logger7.debug(`Baidu upload response: ${JSON.stringify(response.response)}`);
            if (response.status !== 200) {
              throw new Error(`Error: ${response.status}`);
            }
            completedSize += chunk.byteLength;
            Service.cloud.getProvider("baidu" /* Baidu */).setProgress(
              path_exports.relative(cloudDiskModel.remoteRootPath, remotePath),
              completedSize,
              totalSize
            );
            break;
          } catch (error) {
            lastError = error;
            retryCount++;
            if (error instanceof TypeError && error.message.includes("Failed to fetch")) {
              logger7.warn(`\u7F51\u7EDC\u9519\u8BEF\uFF0C\u6B63\u5728\u91CD\u8BD5\u7B2C ${retryCount} \u6B21\u4E0A\u4F20\u5206\u7247 ${index}...`);
              notice("Network error\uFF0Cretry " + retryCount + " upload chunk " + index + "...");
              await new Promise((resolve) => setTimeout(resolve, 1e3 * retryCount));
              continue;
            } else {
              logger7.error(`Error uploading chunk ${index}:` + error.message);
              throw error;
            }
          }
        }
        if (retryCount === maxRetries) {
          logger7.error(`\u4E0A\u4F20\u5206\u7247 ${index} \u5931\u8D25\uFF0C\u5DF2\u8FBE\u5230\u6700\u5927\u91CD\u8BD5\u6B21\u6570`);
          throw new Error(`\u4E0A\u4F20\u5206\u7247 ${index} \u5931\u8D25: ${lastError?.message}`);
        }
      }
    }
    async createFile(remotePath, uploadid, size, blockList, ctime, mtime) {
      const access_token = await Service.auth.getToken("baidu" /* Baidu */);
      if (!access_token) {
        notice("Baidu: token invalid.");
        throw new Error("Create file failed: token invalid.");
      }
      const url = `https://pan.baidu.com/rest/2.0/xpan/file?method=create&access_token=${access_token}`;
      const currentTime = Date.now();
      const params = new URLSearchParams({
        path: remotePath,
        size: size.toString(),
        isdir: "0",
        rtype: "3",
        // 覆盖老文件
        uploadid,
        block_list: JSON.stringify(blockList),
        /* 精确到秒 */
        local_ctime: msToSec(ctime ?? currentTime).toString(),
        local_mtime: msToSec(mtime ?? currentTime).toString()
      });
      try {
        const response = await Zotero.HTTP.request("POST", url, {
          body: params.toString(),
          headers: {
            contentType: "application/x-www-form-urlencoded"
          },
          responseType: "json"
        });
        if (response.status !== 200 || response.response.errno !== 0) {
          logger7.error(`file creation failed, path: ${remotePath}` + response.responseText);
          throw new Error(`${JSON.stringify(response.response)}`);
        }
        return response.response.fs_id.toString();
      } catch (error) {
        logger7.error("Error creating file:" + error.message);
        throw error;
      }
    }
    /* 上传文件到百度云盘
    * @param content: 文件内容
    * @param remotePath: 远程文件路径 
    * @param ctime: 文件创建时间, 精确到秒
    * @param mtime: 文件修改时间, 精确到秒
    */
    async uploadBuffer(content, remotePath, params, notify) {
      const [size, blockMD5List, blockChunks] = await this.prepare(content);
      const [ret, uploadid] = await this.precreate(size, blockMD5List, remotePath);
      if (ret !== 0) {
        logger7.error(`precreate failed, errno: ${ret}, remote_file_path: ${remotePath}`);
        throw new Error(`precreate failed, errno: ${ret}, remote_file_path: ${remotePath}`);
      }
      try {
        const [retDomain, domain] = await this.getUploadDomain(uploadid, remotePath);
        if (retDomain === 0 && domain) {
          if (size !== 0) {
            const startTime = Date.now();
            await this.uploadChunks(domain, uploadid, blockChunks, remotePath, size);
            const endTime = Date.now();
            logger7.debug(`upload, size: ${size}, time: ${endTime - startTime}ms, speed: ${(size / (endTime - startTime)).toFixed(2)}KB/s`);
          }
          const fsId = await this.createFile(
            remotePath,
            uploadid,
            size,
            blockMD5List,
            params?.ctime,
            params?.mtime
          );
          notify?.(fsId, size);
        }
        return true;
      } catch (error) {
        logger7.error(`Error uploading: ${error.message}`);
        throw error;
      }
    }
    async _uploadFile(localFile, notify) {
      if (!this.isActivated()) {
        this.errno = ERRNO.NOT_ACTIVATED;
        throw new Error("Baidu disk is not activated");
      }
      const params = {
        ctime: localFile.ctime,
        mtime: localFile.mtime
      };
      const remoteFilePath = path_exports.join(cloudDiskModel.remoteRootPath, localFile.path);
      const remoteEncrypt = cloudDiskModel.encryptMode;
      logger7.debug(`upload file, localPath: ${localFile.path}, remotePath: ${remoteFilePath}, remoteEncrypt: ${remoteEncrypt}, params: ${JSON.stringify(params)}`);
      const fileContent = await readBinary(localFile.path);
      return this.uploadBuffer(new Uint8Array(fileContent).buffer, remoteFilePath, params, notify);
    }
    async _uploadContent(content, filePath, params) {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      const remoteFilePath = path_exports.join(cloudDiskModel.remoteRootPath, filePath);
      logger7.debug(`upload content, remotePath: ${remoteFilePath}, params: ${JSON.stringify(params)}`);
      return await this.uploadBuffer(content.buffer, remoteFilePath, params);
    }
    async getUserInfo() {
      if (!this.userInfo) {
        const access_token = await Service.auth.getToken("baidu" /* Baidu */);
        try {
          if (!access_token) {
            throw new Error("Baidu: token invalid.");
          }
          const url = `${baiduNetdiskApi.userMng.userInfo.url}&access_token=${access_token}`;
          const response = await Zotero.HTTP.request("GET", url, { responseType: "json" });
          const data = response.response;
          this.userInfo = {
            user_id: data.user_id,
            user_name: data.baidu_name,
            vip_type: data.vip_type
          };
        } catch (error) {
          logger7.error("Error fetching user info:" + error.message);
          notice("Retrieve user info failed");
          throw error;
        }
      }
      return this.userInfo;
    }
    async getStorageInfo() {
      if (!this.storageInfo) {
        const access_token = await Service.auth.getToken("baidu" /* Baidu */);
        try {
          if (!access_token) {
            throw new Error("Baidu: invalid token.");
          }
          const url = `${baiduNetdiskApi.userMng.storageInfo.url}?access_token=${access_token}&checkfree=1&checkexpire=1`;
          const response = await Zotero.HTTP.request("GET", url, {
            headers: {
              "User-Agent": "pan.baidu.com"
            },
            responseType: "json"
          });
          this.storageInfo = response.response;
        } catch (error) {
          logger7.error("Error fetching storage info:" + error.message);
          notice(`Retreive storage info failed, ${error.message}`);
          throw error;
        }
      }
      return this.storageInfo;
    }
    /**
     * 创建文件夹
     * @param folderPath 相对于仓库根目录的路径
     */
    async mkdir(folderPath) {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      const accessToken = await Service.auth.getToken("baidu" /* Baidu */);
      if (!accessToken) {
        notice("Baidu: token invalid.");
        return "";
      }
      const url = "https://pan.baidu.com/rest/2.0/xpan/file";
      const params = new URLSearchParams({
        method: "create",
        access_token: accessToken
      });
      const body = new URLSearchParams({
        path: folderPath,
        isdir: "1",
        rtype: "0"
        // 0 表示不进行重命名，若重名则返回错误
      });
      try {
        const response = await Zotero.HTTP.request("POST", `${url}?${params.toString()}`, {
          body: body.toString(),
          headers: {
            "Content-Type": "application/x-www-form-urlencoded"
          },
          responseType: "json"
        });
        logger7.debug(`[mkdir] path: ${folderPath}, response: ${JSON.stringify(response.response)}`);
        if (response.response.errno !== 0) {
          if (response.response.errno === 31061 || response.response.errno === -8) {
            logger7.debug(`[mkdir] folder already exists: ${folderPath}`);
            return "";
          }
          throw new Error(`\u521B\u5EFA\u6587\u4EF6\u5939\u5931\u8D25: ${response.response.errmsg || "\u672A\u77E5\u9519\u8BEF"}`);
        }
        return "";
      } catch (error) {
        logger7.error(`\u521B\u5EFA\u6587\u4EF6\u5939\u65F6\u53D1\u751F\u9519\u8BEF: ${error}`);
        throw error;
      }
    }
    async _delete(filePath) {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      const accessToken = await Service.auth.getToken("baidu" /* Baidu */);
      if (!accessToken) {
        notice("Baidu: token invalid.");
        return false;
      }
      const remoteFilePath = path_exports.join(cloudDiskModel.remoteRootPath, filePath);
      const url = "https://pan.baidu.com/rest/2.0/xpan/file";
      const params = new URLSearchParams({
        method: "filemanager",
        access_token: accessToken,
        opera: "delete"
      });
      const fileList = JSON.stringify([remoteFilePath]);
      const body = new URLSearchParams({
        async: "1",
        filelist: fileList
      });
      try {
        const response = await Zotero.HTTP.request("POST", `${url}?${params.toString()}`, {
          body: body.toString(),
          headers: {
            "Content-Type": "application/x-www-form-urlencoded"
          },
          responseType: "json"
        });
        logger7.debug(`[deleteFile] path: ${remoteFilePath}, response: ${JSON.stringify(response.response)}`);
        if (response.response.errno !== 0) {
          const errorInfo = typeof response.response.info === "object" ? JSON.stringify(response.response.info) : response.response.info;
          throw new Error(`\u5220\u9664\u6587\u4EF6\u5931\u8D25: ${errorInfo}`);
        }
        return response.response;
      } catch (error) {
        logger7.error(`\u5220\u9664\u6587\u4EF6\u65F6\u53D1\u751F\u9519\u8BEF: ${error}`);
        throw error;
      }
    }
    async copyOrMoveFile(from2, to, isCopy) {
      const remoteSrc = path_exports.join(cloudDiskModel.remoteRootPath, from2);
      const remoteDest = path_exports.join(cloudDiskModel.remoteRootPath, to);
      const accessToken = await Service.auth.getToken("baidu" /* Baidu */);
      if (!accessToken) {
        notice("Baidu: token invalid.");
        return;
      }
      const url = "https://pan.baidu.com/rest/2.0/xpan/file";
      const params = new URLSearchParams({
        method: "filemanager",
        access_token: accessToken,
        opera: isCopy ? "copy" : "move"
      });
      const fileList = JSON.stringify([{
        path: remoteSrc,
        dest: path_exports.dirname(remoteDest),
        newname: path_exports.basename(remoteDest)
      }]);
      const body = new URLSearchParams({
        async: "2",
        filelist: fileList
      });
      try {
        const response = await Zotero.HTTP.request("POST", `${url}?${params.toString()}`, {
          body: body.toString(),
          headers: {
            "Content-Type": "application/x-www-form-urlencoded"
          },
          responseType: "json"
        });
        if (response.response.errno !== 0) {
          throw new Error(response.response.errmsg);
        }
        return response.response;
      } catch (error) {
        logger7.error("\u590D\u5236\u6587\u4EF6\u65F6\u53D1\u751F\u9519\u8BEF\uFF1A" + error.message);
        throw error;
      }
    }
    async _move(oldPath, newPath) {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      await this.copyOrMoveFile(oldPath, newPath, false);
    }
    async copy(from2, to) {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      await this.copyOrMoveFile(from2, to, true);
    }
    async _rename(from2, newName) {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      const accessToken = await Service.auth.getToken("baidu" /* Baidu */);
      if (!accessToken) {
        notice("Baidu: token invalid.");
        return;
      }
      const remotePath = path_exports.join(cloudDiskModel.remoteRootPath, from2);
      const url = "https://pan.baidu.com/rest/2.0/xpan/file";
      const params = new URLSearchParams({
        method: "filemanager",
        access_token: accessToken,
        opera: "rename"
      });
      const fileList = JSON.stringify([{
        path: remotePath,
        newname: newName
      }]);
      const body = new URLSearchParams({
        async: "1",
        filelist: fileList,
        ondup: "overwrite"
      });
      try {
        const response = await Zotero.HTTP.request("POST", `${url}?${params.toString()}`, {
          body: body.toString(),
          headers: {
            "Content-Type": "application/x-www-form-urlencoded"
          },
          responseType: "json"
        });
        if (response.response.errno !== 0) {
          throw new Error(`errno: ${response.response.errno}`);
        }
        return response.response;
      } catch (error) {
        throw Error(`rename file failed: ${error}, path: ${from2}, newName: ${newName}`);
      }
    }
    async exists(path) {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      return this.fileInfoCache.has(path);
    }
    async listAllFiles(at = "/") {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      const listAllFilesWithCursor = async (folderPath, start2, limit2 = 1e3, preview = false) => {
        const accessToken = await Service.auth.getToken("baidu" /* Baidu */);
        if (!accessToken) {
          notice("Baidu: token invalid.");
          return [[], false, void 0];
        }
        const params = new URLSearchParams({
          path: folderPath === "" ? "/" : folderPath,
          access_token: accessToken,
          recursion: "1",
          start: `${start2}`,
          limit: `${limit2}`,
          order: "name",
          web: preview ? "1" : "0"
        });
        return SmartQueue.getInstance().enqueue(async () => {
          try {
            const response = await Zotero.HTTP.request(
              baiduNetdiskApi.fileInfo.listAllFiles.method,
              `${baiduNetdiskApi.fileInfo.listAllFiles.url}&${params.toString()}`,
              {
                responseType: "json",
                successCodes: [200, 400]
              }
            );
            if (response.status !== 200) {
              throw new Error(`Status: ${response.status}, errno: ${response.response}`);
            }
            if (response.response.list === null) {
              throw new Error(`List is null`);
            }
            const files = response.response.list.map((file) => {
              if (file.local_ctime > file.server_ctime || file.local_mtime > file.server_mtime) {
                logger7.info(
                  `Local file is newer than remote file, file: ${file.path},
                                    local_ctime: ${file.local_ctime}, local_mtime: ${file.local_mtime}, 
                                    server_ctime: ${file.server_ctime}, server_mtime: ${file.server_mtime}`
                );
              }
              const ctime = Math.min(file.local_ctime, file.server_ctime);
              const mtime = Math.min(file.local_mtime, file.server_mtime);
              return {
                path: file.path,
                isdir: file.isdir === 1,
                fsid: file.fs_id,
                ctime,
                mtime,
                size: file.size,
                thumb: file.thumbs ? file.thumbs["url1"] : void 0
              };
            });
            if (response.response.has_more === 1) {
              return [files, true, response.response.cursor];
            }
            return [files, false, void 0];
          } catch (error) {
            logger7.error(`list all files failed, error: ${error.message}, at: ${folderPath}`);
            throw error;
          }
        }, `baidu-listall:${folderPath}`, "baidu-list" /* BAIDU_LISTALL */);
      };
      logger7.debug(`list all files, remoteRootPath: ${cloudDiskModel.remoteRootPath}`);
      const limit = 1e3;
      const allFiles = [];
      const start = 0;
      this.fileInfoCache.clear();
      try {
        logger7.debug(`List all files, folderPath: ${at}`);
        let [files, hasMore, nextCursor] = await listAllFilesWithCursor(at, start, limit, false);
        allFiles.push(...files);
        while (hasMore) {
          [files, hasMore, nextCursor] = await listAllFilesWithCursor(at, nextCursor, limit, false);
          allFiles.push(...files);
        }
        logger7.debug("List all files: " + allFiles.length);
        for (const entry of allFiles) {
          this.fileInfoCache.set(entry.path, entry);
        }
        return allFiles;
      } catch (error) {
        logger7.error(`List all files failed, error: ${error.message}, folderPath: ${at}`);
        throw error;
      }
    }
    async listFilesAt(filePath, forceInVault = true, preview = false) {
      if (!this.isActivated()) {
        throw new Error("Baidu disk is not activated");
      }
      const realPath = forceInVault ? path_exports.join(cloudDiskModel.remoteRootPath, filePath) : filePath;
      const limit = 1e3;
      let offset = 0;
      const result = [];
      const token = await Service.auth.getToken("baidu" /* Baidu */);
      if (!token) {
        notice("Baidu: token invalid.");
        return [];
      }
      let hasMore = true;
      while (hasMore) {
        const params = new URLSearchParams({
          access_token: token,
          dir: realPath,
          start: `${offset}`,
          limit: `${limit}`,
          web: "1"
        });
        const response = await Zotero.HTTP.request(
          baiduNetdiskApi.fileInfo.listFiles.method,
          `${baiduNetdiskApi.fileInfo.listFiles.url}&${params.toString()}`,
          {
            headers: {
              "User-Agent": "pan.baidu.com"
            },
            responseType: "json"
          }
        );
        if (response.status !== 200) {
          logger7.error(response.responseText ?? "unknown");
          throw new Error(`${response.status}`);
        }
        logger7.debug(response.responseText ?? "unkown error");
        response.response.list.map((file) => {
          const ctime = Math.min(file.local_ctime, file.server_ctime);
          const mtime = Math.min(file.local_mtime, file.server_mtime);
          result.push({
            path: file.path,
            isdir: file.isdir === 1,
            fsid: file.fs_id.toString(),
            ctime,
            mtime,
            size: file.size,
            thumb: file.thumbs ? file.thumbs["url3"] : void 0
          });
        });
        if (!response.response.list.length || response.response.list.length < limit) {
          logger7.debug(`List ${filePath} done, found ${result.length} items.`);
          hasMore = false;
        } else {
          offset += 1e3;
        }
      }
      return result;
    }
    async authorize() {
      logger7.info("baidu authorize");
      return await this.defaultAuthorize("baidu" /* Baidu */);
    }
    async refreshToken() {
      logger7.info("baidu refresh token");
      return await Service.auth.checkAndRefreshToken("baidu" /* Baidu */);
    }
    async updateMediaRecord(filePath, playCursor) {
      throw new Error("Baidu: not implementd.");
    }
    async getDownloadUrlOf(item) {
      const dlAddr = await this.getDlLink([parseInt(item.fsid)]);
      if (!dlAddr) {
        throw new Error(`Cannot get download addr.`);
      }
      item.dlLink = dlAddr[item.fsid];
      return item.dlLink;
    }
    async _searchFileAt(filePath, category = 1 /* Image */) {
      const token = await Service.auth.getToken("baidu" /* Baidu */);
      if (!token) {
        throw new Error("Baidu: token invalid.");
      }
      if (category !== 0 /* Document */) {
        throw new Error(`${category} not supported.`);
      }
      let parentDir = path_exports.dirname(filePath);
      if (!parentDir.startsWith("/")) {
        parentDir = "/" + parentDir;
      }
      const key = path_exports.basename(filePath);
      const params = new URLSearchParams({
        method: "search",
        access_token: token,
        key,
        recursion: "1"
        // dir: parentDir,
        // num: '1000',
        // category: '4', // 文件类型，1 视频、2 音频、3 图片、4 文档、5 应用、6 其他、7 种子
      });
      logger7.debug(`Search key: ${key}`);
      let retryCount = 0;
      const maxTry = 3;
      let lastError = null;
      let finalFile = null;
      while (retryCount < maxTry) {
        try {
          const response = await Zotero.HTTP.request(
            "GET",
            `https://pan.baidu.com/rest/2.0/xpan/file?${params.toString()}`,
            {
              headers: {
                "User-Agent": "pan.baidu.com"
              },
              responseType: "json"
            }
          );
          if (response.status !== 200) {
            throw new Error(`${response.status}:${response.responseText}`);
          }
          const fileList = response.response.list;
          if (!Array.isArray(fileList)) {
            throw new Error("File list not found.");
          }
          logger7.debug(JSON.stringify({
            filePath,
            SearchResult: response.response
          }));
          const expectedFileName = path_exports.basename(filePath);
          logger7.debug(`Expected name: ${expectedFileName}`);
          for (const item of fileList) {
            if (item.server_filename === expectedFileName) {
              logger7.debug("File found.");
              finalFile = {
                path: item.path,
                fsid: item.fs_id.toString(),
                size: item.size,
                isdir: item.isdir,
                ctime: item.local_ctime,
                mtime: item.local_mtime
              };
              break;
            }
          }
          if (finalFile) {
            const dlAddr = await this.getDlLink([parseInt(finalFile.fsid)]);
            if (!dlAddr) {
              throw new Error(`Cannot get download addr.`);
            }
            finalFile.dlLink = dlAddr[finalFile.fsid];
            return finalFile;
          } else {
            retryCount += 1;
            logger7.warn(`Retry ${retryCount}`);
            continue;
          }
        } catch (error) {
          await sleep(500);
          retryCount += 1;
          logger7.warn(`Retry ${retryCount}`);
          lastError = error;
        }
      }
      if (lastError) {
        throw lastError;
      } else {
        return finalFile;
      }
    }
    async fuzzySearchFile(query, category, accessToken) {
      const token = await Service.auth.getToken("baidu" /* Baidu */);
      if (!token) {
        notice("Baidu: invalid token.");
        return [];
      }
      if (category !== 0 /* Document */) {
        throw new Error(`${category} not supported.`);
      }
      const params = new URLSearchParams({
        method: "search",
        access_token: token,
        key: query,
        recursion: "1"
        // dir: parentDir,
        // num: '1000',
        // category: '4', // 文件类型，1 视频、2 音频、3 图片、4 文档、5 应用、6 其他、7 种子
      });
      try {
        const response = await Zotero.HTTP.request(
          "GET",
          `https://pan.baidu.com/rest/2.0/xpan/file?${params.toString()}`,
          {
            headers: {
              "User-Agent": "pan.baidu.com"
            },
            responseType: "json"
          }
        );
        if (response.status !== 200) {
          throw new Error(`${response.status}: ${response.responseText}`);
        }
        const fileList = response.response.list;
        if (!Array.isArray(fileList)) {
          throw new Error("File list not found.");
        }
        logger7.debug(JSON.stringify({
          SearchResult: response
        }));
        const result = [];
        for (const item of fileList) {
          logger7.debug(`Item: ${item.server_filename}`);
          result.push({
            path: item.path,
            fsid: item.fs_id.toString(),
            size: item.size,
            isdir: item.isdir,
            ctime: item.local_ctime,
            mtime: item.local_mtime
          });
        }
        return fileList.map((item) => {
          return {
            path: item.path,
            fsid: item.fs_id,
            size: item.size,
            isdir: item.isdir,
            ctime: item.local_ctime,
            mtime: item.local_mtime
          };
        });
      } catch (error) {
        logger7.error(error);
        return [];
      }
    }
  };

  // src/modules/service/cloud-service.ts
  var logger8 = createLogger("cloud-service");
  var CloudService = class _CloudService {
    static instance;
    provider = null;
    static getInstance() {
      if (!this.instance) {
        this.instance = new _CloudService();
      }
      return this.instance;
    }
    setProvider(cloudDiskType) {
      switch (cloudDiskType) {
        case "baidu" /* Baidu */:
          this.provider = BaiduDiskProvider.getInstance();
          break;
        // case CloudDiskType.Aliyun:
        //     this.provider = AliyunDiskProvider.getInstance();
        //     break;
        // case CloudDiskType.OneDrive:
        //     this.provider = OnedriveProvider.getInstance();
        //     break;
        // case CloudDiskType.Onelife:
        //     this.provider = OneLifeProvider.getInstance();
        //     break;
        // case CloudDiskType.Quark:
        //     this.provider = QuarkProvider.getInstance();
        //     break;
        // case CloudDiskType.Nutstore:
        //     this.provider = NutstoreProvider.getInstance();
        //     break;
        // case CloudDiskType.InfiniCloud:
        //     this.provider = InfiniCloudProvider.getInstance();
        //     break;
        // case CloudDiskType.COS:
        //     this.provider = COSProvider.getInstance();
        //     break;
        // case CloudDiskType.Https:
        //     this.provider = HttpsProvider.getInstance();
        //     break;
        default:
          throw new Error(`No cloud provider found, cloud type: ${cloudDiskType}`);
      }
    }
    getProviderByType(cloudDiskType) {
      switch (cloudDiskType) {
        case "baidu" /* Baidu */:
          return BaiduDiskProvider.getInstance();
        // case CloudDiskType.Aliyun:
        //     return AliyunDiskProvider.getInstance();
        // case CloudDiskType.OneDrive:
        //     return OnedriveProvider.getInstance();
        // case CloudDiskType.Onelife:
        //     return OneLifeProvider.getInstance();
        // case CloudDiskType.Https:
        //     return HttpsProvider.getInstance();
        // case CloudDiskType.Quark:
        //     return QuarkProvider.getInstance();
        // case CloudDiskType.Nutstore:
        //     return NutstoreProvider.getInstance();
        // case CloudDiskType.InfiniCloud:
        //     return InfiniCloudProvider.getInstance();
        // case CloudDiskType.COS:
        //     return COSProvider.getInstance();
        default:
          throw new Error("Unsupported cloud type.");
      }
    }
    getProvider(cloudDiskType) {
      if (cloudDiskType) {
        return this.getProviderByType(cloudDiskType);
      } else {
        return this.getProviderByType(cloudDiskModel.selectedCloudDisk);
      }
    }
    async init() {
      logger8.info("Init service...");
      if (!this.provider) {
        throw new Error("No cloud provider set");
      }
      if (!this.provider.isLogedIn()) {
        await this.provider.login();
      }
      try {
        const exists = await this.provider.exists("/");
        if (!exists) {
          logger8.debug(`Root directory not exists, creating..., path: ${cloudDiskModel.remoteRootPath}`);
          await this.provider.mkdir("/");
        } else {
          logger8.debug(`Root directory already exists, path: ${cloudDiskModel.remoteRootPath}`);
        }
        logger8.info(`Root directory created, path: ${cloudDiskModel.remoteRootPath}`);
      } catch (error) {
        logger8.error("Check root folder failed: " + error.message);
      }
    }
    async exit() {
      logger8.info("Exit service...");
      this.provider?.logout();
    }
  };

  // src/modules/service/index.ts
  var Service = {
    auth: cloudAuthService,
    cloud: CloudService.getInstance()
    // getNetworkErrorMessage,
  };

  // src/modules/preferenceScript.ts
  var logger9 = logger_exports.createLogger("preference");
  async function registerPrefsScripts(_window) {
    logger9.info("registerPrefsScripts.");
    if (!addon.data.prefs) {
      addon.data.prefs = {
        window: _window
      };
    } else {
      addon.data.prefs.window = _window;
    }
    updatePrefsUI();
    bindPrefEvents();
  }
  async function updatePrefsUI() {
    const renderLock = ztoolkit.getGlobal("Zotero").Promise.defer();
    if (addon.data.prefs?.window == void 0) {
      logger9.warn("No window object.");
      return;
    }
    logger9.info(`Update auth status: ${getPref("isAuthed")}`);
    const provider = Service.cloud.getProvider("baidu" /* Baidu */);
    try {
      const authStatus = addon.data.prefs.window.document.getElementById("baidu-auth-status");
      const userInfoElem = addon.data.prefs.window.document.getElementById("baidu-user-info");
      if (!userInfoElem || !authStatus) {
        return;
      }
      if (provider.isLogedIn()) {
        const userInfo = await Service.cloud.getProvider("baidu" /* Baidu */).getUserInfo();
        const storageInfo = await Service.cloud.getProvider("baidu" /* Baidu */).getStorageInfo();
        if (storageInfo) {
          const showInfo = `${userInfo.user_name} - ${formatFileSize(storageInfo.used)} / ${formatFileSize(storageInfo.total)}`;
          userInfoElem.setAttribute("value", showInfo);
        }
        const token = provider.token;
        if (Service.auth.isValidToken(token)) {
          setPref("isAuthed", true);
        }
        authStatus.setAttribute("value", getPref("isAuthed") ? `\u5DF2\u6388\u6743, \u5230\u671F: ${token.expiresAt}` : "\u672A\u6388\u6743");
      } else {
        userInfoElem.setAttribute("value", "offline");
      }
    } finally {
      renderLock.resolve();
    }
    await renderLock.promise;
  }
  function bindPrefEvents() {
    addon.data.prefs.window.document?.querySelector(
      `#zotero-prefpane-${config.addonRef}-enable`
    )?.addEventListener("command", (e) => {
      ztoolkit.log(e);
      addon.data.prefs.window.alert(
        `Successfully changed to ${e.target.checked}!`
      );
    });
    addon.data.prefs.window.document?.querySelector(
      `#zotero-prefpane-${config.addonRef}-input`
    )?.addEventListener("change", (e) => {
      ztoolkit.log(e);
      addon.data.prefs.window.alert(
        `Successfully changed to ${e.target.value}!`
      );
    });
  }

  // src/utils/ztoolkit.ts
  function createZToolkit() {
    const _ztoolkit = new ZoteroToolkit();
    initZToolkit(_ztoolkit);
    return _ztoolkit;
  }
  function initZToolkit(_ztoolkit) {
    const env = "production";
    _ztoolkit.basicOptions.log.prefix = `[${config.addonName}]`;
    _ztoolkit.basicOptions.log.disableConsole = env === "production";
    _ztoolkit.UI.basicOptions.ui.enableElementJSONLog = false;
    _ztoolkit.UI.basicOptions.ui.enableElementDOMLog = false;
    _ztoolkit.basicOptions.api.pluginID = config.addonID;
    _ztoolkit.ProgressWindow.setIconURI(
      "default",
      `chrome://${config.addonRef}/content/icons/favicon.png`
    );
  }

  // src/modules/sync-vault.ts
  var logger10 = createLogger("sync-vault-app");
  var SyncVaultFactory = class {
    static registerPrefs() {
      Zotero.PreferencePanes.register({
        pluginID: addon.data.config.addonID,
        src: rootURI + "content/preferences.xhtml",
        label: getString("prefs-title"),
        image: `chrome://${addon.data.config.addonRef}/content/icons/favicon.png`
      });
    }
    static registerStyleSheet(win) {
      const doc = win.document;
      const styles = ztoolkit.UI.createElement(doc, "link", {
        properties: {
          type: "text/css",
          rel: "stylesheet",
          href: `chrome://${addon.data.config.addonRef}/content/zoteroPane.css`
        }
      });
      doc.documentElement?.appendChild(styles);
    }
    static async buildSyncApp() {
      logger10.info("sync vault.");
      let deviceName = getPref("syncvault-devicename") ?? "";
      if (deviceName.length === 0) {
        deviceName = `zetero_${Zotero.Utilities.randomString(8)}`;
        setPref("syncvault-devicename", deviceName);
      }
      const deviceType = getDeviceType();
      logger10.info("Hello: " + deviceName + ", type: " + deviceType);
      CloudAuthAPI.init(deviceName, deviceType);
    }
  };
  var SyncVaultApp = class _SyncVaultApp {
    static instance;
    currentWin = null;
    isWorking = false;
    syncFiles = 0;
    syncSize = 0;
    provider = Service.cloud.getProvider("baidu" /* Baidu */);
    constructor() {
    }
    static getInstance() {
      if (!_SyncVaultApp.instance) {
        _SyncVaultApp.instance = new _SyncVaultApp();
      }
      return _SyncVaultApp.instance;
    }
    addLog(message, type = "info") {
      const logElement = this.currentWin?.document.getElementById("syncvault-sync-log");
      if (!logElement) {
        logger10.warn("Log element not found!");
        return;
      }
      const timestamp = (/* @__PURE__ */ new Date()).toLocaleTimeString();
      const colorMap = {
        info: "black",
        success: "green",
        warning: "orange",
        error: "red"
      };
      const logEntry = this.currentWin.document.createElement("div");
      logEntry.innerHTML = `<span style="color: gray;">[${timestamp}]</span> <span style="color: ${colorMap[type]};">${message}</span>`;
      logElement.appendChild(logEntry);
      logElement.scrollTop = logElement.scrollHeight;
    }
    uploadSyncStat() {
      const syncStatFiles = this.currentWin?.document.getElementById("sync-stats-files");
      const syncStatSize = this.currentWin?.document.getElementById("sync-stats-size");
      const syncStatLast = this.currentWin?.document.getElementById("sync-stats-last");
      if (syncStatLast) {
        syncStatLast.setAttribute("value", `\u6700\u540E\u540C\u6B65: ${(/* @__PURE__ */ new Date()).toLocaleString()}`);
      }
      if (syncStatFiles) {
        syncStatFiles.setAttribute("value", `\u6587\u4EF6: ${this.syncFiles}`);
      }
      if (syncStatSize) {
        syncStatSize.setAttribute("value", `\u5927\u5C0F: ${formatFileSize(this.syncSize)}`);
      }
    }
    clearLog(win) {
      const logElement = (win ?? this.currentWin)?.document.getElementById("syncvault-sync-log");
      if (logElement) {
        logElement.innerHTML = "<div>\u65E5\u5FD7\u5DF2\u6E05\u7A7A</div>";
      }
    }
    updateSyncProgress(current, total, fileName) {
      const progress = total > 0 ? Math.round(current / total * 100) : 0;
      this.addLog(`\u540C\u6B65\u8FDB\u5EA6: ${current}/${total} (${progress}%) - ${fileName} ...`);
    }
    async getAllAttachments() {
      const s = new Zotero.Search({
        libraryID: Zotero.Libraries.userLibraryID
      });
      s.addCondition("itemType", "is", "attachment");
      const attachmentIDs = await s.search();
      logger10.info(`\u627E\u5230 ${attachmentIDs.length} \u4E2A\u9644\u4EF6`);
      const items = [];
      for (const id of attachmentIDs) {
        const item = await Zotero.Items.getAsync(id);
        this.addLog(JSON.stringify(item));
        const filePath = item.getFilePath();
        if (filePath === false) {
          ztoolkit.log(`Attachment ${id} has no file.`);
          continue;
        }
        const file = Zotero.File.pathToFile(filePath);
        const stat = {
          id: item.id,
          ctime: new Date(item.dateAdded).getTime(),
          mtime: new Date(item.dateModified).getTime(),
          size: file.fileSize,
          path: filePath,
          title: item.getField("title"),
          type: item.itemTypeID
        };
        logger10.debug("Attachment Stat: " + stat);
        items.push(stat);
      }
      return items;
    }
    async sync(win) {
      if (this.isWorking) {
        notice("Is still syncing...");
        return;
      }
      this.currentWin = win;
      this.isWorking = true;
      try {
        this.addLog("\u83B7\u53D6\u672C\u5730\u6587\u4EF6\u5BF9\u8C61...", "info");
        const localItems = await this.getAllAttachments();
        this.addLog(`\u627E\u5230 ${localItems.length} \u4E2A\u6587\u4EF6\u3002`, "info");
        const totalSize = localItems.reduce((acc, item) => acc + (item.size || 0), 0);
        this.addLog(`\u603B\u5927\u5C0F: ${formatFileSize(totalSize)}`, "info");
        this.addLog("\u68C0\u67E5\u6388\u6743\u72B6\u6001...", "info");
        const token = await Service.auth.getToken("baidu" /* Baidu */);
        if (!token) {
          throw new Error("\u6388\u6743\u65E0\u6548\uFF0C\u8BF7\u5148\u6388\u6743\u767E\u5EA6\u7F51\u76D8\uFF01");
        } else {
          const token2 = Service.cloud.getProvider("baidu" /* Baidu */).token;
          this.addLog(`\u6388\u6743\u6709\u6548\uFF0C\u8FC7\u671F\u65F6\u95F4: ${token2.expiresAt}`, "success");
        }
        await this.provider.login();
        this.addLog("\u68C0\u67E5\u4E91\u76D8\u72B6\u6001...", "info");
        const storageInfo = await this.provider.getStorageInfo();
        if (storageInfo) {
          this.addLog(`\u5DF2\u7528\u7A7A\u95F4: ${formatFileSize(storageInfo.used)} / ${formatFileSize(storageInfo.total)}`, "info");
          if (storageInfo.total - storageInfo.used < totalSize) {
            throw new Error("\u5B58\u50A8\u7A7A\u95F4\u4E0D\u8DB3\uFF0C\u65E0\u6CD5\u5B8C\u6210\u540C\u6B65\uFF01");
          } else {
            this.addLog("\u5B58\u50A8\u7A7A\u95F4\u5145\u8DB3", "success");
          }
        } else {
          throw new Error("\u83B7\u53D6\u5B58\u50A8\u7A7A\u95F4\u4FE1\u606F\u5931\u8D25\uFF0C\u65E0\u6CD5\u7EE7\u7EED\u540C\u6B65\uFF01");
        }
        const remoteFolderPath = getPref("baiduSyncFolder") ?? `/Zotero/${Zotero.Libraries.userLibrary.name}`;
        await this.provider.mkdir(remoteFolderPath);
        const cloudFiles = await this.provider.listAllFiles(remoteFolderPath);
        this.addLog(`\u4E91\u7AEF\u5DF2\u5B58\u5728 ${cloudFiles.length} \u4E2A\u6587\u4EF6`, "info");
      } catch (error) {
        this.addLog(`\u540C\u6B65\u5931\u8D25: ${error.message}`, "error");
        logger10.error("Sync failed:" + error.message);
      } finally {
        this.isWorking = false;
      }
    }
    async upload(win) {
      if (this.isWorking) {
        notice("Is still syncing...");
        return;
      }
      this.currentWin = win;
      this.isWorking = true;
      const provider = Service.cloud.getProvider("baidu" /* Baidu */);
      try {
        const allItems = await this.getAllAttachments();
        this.addLog(`\u53D1\u73B0 ${allItems.length} \u4E2A\u9644\u4EF6`);
        if (allItems.length === 0) {
          return;
        }
        this.addLog("\u767B\u9646\u4E91\u76D8...");
        await provider.login();
        const dataDir = Zotero.DataDirectory.dir;
        const remoteFolder = getPref("baiduSyncFolder");
        this.addLog(`\u83B7\u53D6\u4E91\u7AEF\u4FE1\u606F ${remoteFolder}...`, "info");
        if (!remoteFolder) {
          this.addLog("Invalid remoteFolder: " + remoteFolder, "error");
          return;
        }
        await provider.mkdir(remoteFolder);
        const remoteFiles = await provider.listAllFiles(remoteFolder);
        const snapshot = /* @__PURE__ */ new Map();
        for (const file of remoteFiles) {
          snapshot.set(file.path, file);
        }
        let idx = 1;
        for (const item of allItems) {
          const content = await readBinary(item.path);
          const relPath = path_exports.relative(dataDir, item.path);
          const remotePath = path_exports.join(getPref("baiduSyncFolder"), relPath);
          const remoteItem = snapshot.get(remotePath);
          this.updateSyncProgress(idx++, allItems.length, relPath);
          const result = await provider.uploadContent(new Uint8Array(content), relPath, {
            ctime: item.ctime,
            mtime: item.mtime
          });
          if (result.success) {
            this.addLog(`\u4E0A\u4F20 ${item.path} -> ${remotePath}, \u5927\u5C0F: ${content.byteLength}`, "success");
            this.syncFiles++;
            this.syncSize += item.size;
          } else {
            this.addLog(`\u4E0A\u4F20\u5931\u8D25 ${item.path} -> ${remotePath}, \u9519\u8BEF\u7801: ${result.error?.code}, \u63D0\u793A: ${result.error?.message}`);
          }
        }
      } catch (error) {
        this.addLog(error.message, "error");
      } finally {
        this.isWorking = false;
        this.uploadSyncStat();
      }
    }
    async downloadItemFrom(entry) {
      const relPath = entry.path.replace(cloudDiskModel.remoteRootPath, "");
      try {
        const result = await this.provider.downloadFile(entry.path);
        if (result.success) {
          this.addLog(`Fetch content ${relPath}, size: ${entry.size}`, "success");
          this.syncFiles++;
          this.syncSize += entry.size;
        } else {
          throw new Error(`Error, code: ${result.error?.code}, message: ${result.error?.message}`);
        }
        await createAttachmentItem(relPath, result.data, {
          ctime: secToMs(entry.ctime),
          mtime: secToMs(entry.mtime)
        }, this.addLog.bind(this));
      } catch (error) {
        this.addLog(error.message, "error");
      }
    }
    async download(win) {
      if (this.isWorking) {
        notice("Is still syncing...");
        return;
      }
      this.currentWin = win;
      this.isWorking = true;
      const provider = Service.cloud.getProvider("baidu" /* Baidu */);
      try {
        this.addLog(`\u767B\u9646\u4E91\u76D8...`);
        await provider.login();
        this.addLog("\u83B7\u53D6\u4E91\u7AEF\u6587\u4EF6\u4FE1\u606F...", "info");
        await provider.mkdir(cloudDiskModel.remoteRootPath);
        const remoteFiles = (await provider.listAllFiles(cloudDiskModel.remoteRootPath)).filter((f) => !f.isdir);
        const snapshot = /* @__PURE__ */ new Map();
        for (const file of remoteFiles) {
          snapshot.set(file.path, file);
        }
        this.addLog(`\u53D1\u73B0 ${remoteFiles.length} \u4E2A\u6761\u76EE`);
        let idx = 1;
        for (const entry of remoteFiles) {
          this.updateSyncProgress(idx++, remoteFiles.length, entry.path);
          await this.downloadItemFrom(entry);
        }
      } catch (error) {
        this.addLog(error.message, "error");
      } finally {
        this.isWorking = false;
        this.uploadSyncStat();
      }
    }
  };

  // src/hooks.ts
  var logger11 = logger_exports.createLogger("hooks");
  async function onStartup() {
    await Promise.all([
      Zotero.initializationPromise,
      Zotero.unlockPromise,
      Zotero.uiReadyPromise
    ]);
    initLocale();
    SyncVaultFactory.registerPrefs();
    await Promise.all(
      Zotero.getMainWindows().map((win) => onMainWindowLoad(win))
    );
    addon.data.initialized = true;
  }
  async function onMainWindowLoad(win) {
    addon.data.ztoolkit = createZToolkit();
    win.MozXULElement.insertFTLIfNeeded(
      `${addon.data.config.addonRef}-mainWindow.ftl`
    );
    await Zotero.Promise.delay(1e3);
    SyncVaultFactory.registerStyleSheet(win);
    SyncVaultFactory.buildSyncApp();
  }
  async function onMainWindowUnload(win) {
    ztoolkit.unregisterAll();
    addon.data.dialog?.window?.close();
  }
  function onShutdown() {
    ztoolkit.unregisterAll();
    addon.data.dialog?.window?.close();
    addon.data.alive = false;
    delete Zotero[addon.data.config.addonInstance];
    if (CloudAuthAPI.heartbeartInterval) {
      Zotero.getMainWindow().clearInterval(CloudAuthAPI.heartbeartInterval);
      CloudAuthAPI.heartbeartInterval = 0;
    }
  }
  async function onNotify(event, type, ids, extraData) {
    ztoolkit.log("notify", event, type, ids, extraData);
    if (event == "select" && type == "tab" && extraData[ids[0]].type == "reader") {
    } else {
      return;
    }
  }
  async function onPrefsEvent(type, data) {
    switch (type) {
      case "load":
        registerPrefsScripts(data.window);
        break;
      case "baidu-auth":
        Service.auth.authorize("baidu" /* Baidu */);
        break;
      case "baidu-refresh":
        {
          const token = await Service.auth.getToken("baidu" /* Baidu */);
          if (token) {
            await Service.cloud.getProvider("baidu" /* Baidu */).login();
            logger11.info("Refresh prefs ui.");
            updatePrefsUI();
          }
        }
        break;
      case "sync-vault-pref":
        break;
      case "syncvault-sync-now":
        SyncVaultApp.getInstance().sync(data.window);
        break;
      case "syncvault-only-upload":
        SyncVaultApp.getInstance().upload(data.window);
        break;
      case "syncvault-only-download":
        SyncVaultApp.getInstance().download(data.window);
        break;
      case "syncvault-clear-log":
        SyncVaultApp.getInstance().clearLog(data.window);
        break;
      default:
        return;
    }
  }
  function onShortcuts(type) {
    switch (type) {
      case "larger":
        break;
      case "smaller":
        break;
      default:
        break;
    }
  }
  function onDialogEvents(type) {
    switch (type) {
      // case "dialogExample":
      //   HelperExampleFactory.dialogExample();
      //   break;
      // case "clipboardExample":
      //   HelperExampleFactory.clipboardExample();
      //   break;
      // case "filePickerExample":
      //   HelperExampleFactory.filePickerExample();
      //   break;
      // case "progressWindowExample":
      //   HelperExampleFactory.progressWindowExample();
      //   break;
      // case "vtableExample":
      //   HelperExampleFactory.vtableExample();
      //   break;
      default:
        break;
    }
  }
  var hooks_default = {
    onStartup,
    onShutdown,
    onMainWindowLoad,
    onMainWindowUnload,
    onNotify,
    onPrefsEvent,
    onShortcuts,
    onDialogEvents
  };

  // src/addon.ts
  var Addon = class {
    data;
    // Lifecycle hooks
    hooks;
    // APIs
    api;
    constructor() {
      this.data = {
        alive: true,
        config,
        env: "production",
        initialized: false,
        ztoolkit: createZToolkit()
      };
      this.hooks = hooks_default;
      this.api = {};
    }
  };
  var addon_default = Addon;

  // src/index.ts
  var basicTool2 = new BasicTool();
  if (!basicTool2.getGlobal("Zotero")[config.addonInstance]) {
    _globalThis.addon = new addon_default();
    defineGlobal("ztoolkit", () => {
      return _globalThis.addon.data.ztoolkit;
    });
    Zotero[config.addonInstance] = addon;
  }
  function defineGlobal(name, getter) {
    Object.defineProperty(_globalThis, name, {
      get() {
        return getter ? getter() : basicTool2.getGlobal(name);
      }
    });
  }
})();
